@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeConfigurationProperty
import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeInputArtifactDetails
import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeOutputArtifactDetails
import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeSettings
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeConfigurationProperty.Companion.toKotlin as customActionTypeConfigurationPropertyToKotlin
import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeInputArtifactDetails.Companion.toKotlin as customActionTypeInputArtifactDetailsToKotlin
import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeOutputArtifactDetails.Companion.toKotlin as customActionTypeOutputArtifactDetailsToKotlin
import com.pulumi.aws.codepipeline.kotlin.outputs.CustomActionTypeSettings.Companion.toKotlin as customActionTypeSettingsToKotlin

/**
 * Builder for [CustomActionType].
 */
@PulumiTagMarker
public class CustomActionTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomActionTypeArgs = CustomActionTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomActionTypeArgsBuilder.() -> Unit) {
        val builder = CustomActionTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomActionType {
        val builtJavaResource = com.pulumi.aws.codepipeline.CustomActionType(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomActionType(builtJavaResource)
    }
}

/**
 * Provides a CodeDeploy CustomActionType
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codepipeline.CustomActionType;
 * import com.pulumi.aws.codepipeline.CustomActionTypeArgs;
 * import com.pulumi.aws.codepipeline.inputs.CustomActionTypeInputArtifactDetailsArgs;
 * import com.pulumi.aws.codepipeline.inputs.CustomActionTypeOutputArtifactDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomActionType("example", CustomActionTypeArgs.builder()
 *             .category("Build")
 *             .inputArtifactDetails(CustomActionTypeInputArtifactDetailsArgs.builder()
 *                 .maximumCount(1)
 *                 .minimumCount(0)
 *                 .build())
 *             .outputArtifactDetails(CustomActionTypeOutputArtifactDetailsArgs.builder()
 *                 .maximumCount(1)
 *                 .minimumCount(0)
 *                 .build())
 *             .providerName("example")
 *             .version("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeDeploy CustomActionType using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:codepipeline/customActionType:CustomActionType example Build:pulumi:1
 * ```
 *
 */
public class CustomActionType internal constructor(
    override val javaResource: com.pulumi.aws.codepipeline.CustomActionType,
) : KotlinCustomResource(javaResource, CustomActionTypeMapper) {
    /**
     * The action ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The category of the custom action. Valid values: `Source`, `Build`, `Deploy`, `Test`, `Invoke`, `Approval`
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The configuration properties for the custom action. Max 10 items.
     */
    public val configurationProperties: Output<List<CustomActionTypeConfigurationProperty>>?
        get() = javaResource.configurationProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        customActionTypeConfigurationPropertyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The details of the input artifact for the action.
     */
    public val inputArtifactDetails: Output<CustomActionTypeInputArtifactDetails>
        get() = javaResource.inputArtifactDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                customActionTypeInputArtifactDetailsToKotlin(args0)
            })
        })

    /**
     * The details of the output artifact of the action.
     */
    public val outputArtifactDetails: Output<CustomActionTypeOutputArtifactDetails>
        get() = javaResource.outputArtifactDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                customActionTypeOutputArtifactDetailsToKotlin(args0)
            })
        })

    /**
     * The creator of the action being called.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The provider of the service used in the custom action
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })

    /**
     * The settings for an action type.
     */
    public val settings: Output<CustomActionTypeSettings>?
        get() = javaResource.settings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customActionTypeSettingsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The version identifier of the custom action.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object CustomActionTypeMapper : ResourceMapper<CustomActionType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codepipeline.CustomActionType::class == javaResource::class

    override fun map(javaResource: Resource): CustomActionType = CustomActionType(
        javaResource as
            com.pulumi.aws.codepipeline.CustomActionType,
    )
}

/**
 * @see [CustomActionType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomActionType].
 */
public suspend fun customActionType(
    name: String,
    block: suspend CustomActionTypeResourceBuilder.() -> Unit,
): CustomActionType {
    val builder = CustomActionTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomActionType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customActionType(name: String): CustomActionType {
    val builder = CustomActionTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
