@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.CustomActionTypeArgs.builder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeConfigurationPropertyArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeConfigurationPropertyArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeInputArtifactDetailsArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeInputArtifactDetailsArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeOutputArtifactDetailsArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeOutputArtifactDetailsArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeSettingsArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeDeploy CustomActionType
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codepipeline.CustomActionType;
 * import com.pulumi.aws.codepipeline.CustomActionTypeArgs;
 * import com.pulumi.aws.codepipeline.inputs.CustomActionTypeInputArtifactDetailsArgs;
 * import com.pulumi.aws.codepipeline.inputs.CustomActionTypeOutputArtifactDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomActionType("example", CustomActionTypeArgs.builder()
 *             .category("Build")
 *             .inputArtifactDetails(CustomActionTypeInputArtifactDetailsArgs.builder()
 *                 .maximumCount(1)
 *                 .minimumCount(0)
 *                 .build())
 *             .outputArtifactDetails(CustomActionTypeOutputArtifactDetailsArgs.builder()
 *                 .maximumCount(1)
 *                 .minimumCount(0)
 *                 .build())
 *             .providerName("example")
 *             .version("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeDeploy CustomActionType using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:codepipeline/customActionType:CustomActionType example Build:pulumi:1
 * ```
 * @property category The category of the custom action. Valid values: `Source`, `Build`, `Deploy`, `Test`, `Invoke`, `Approval`
 * @property configurationProperties The configuration properties for the custom action. Max 10 items.
 * @property inputArtifactDetails The details of the input artifact for the action.
 * @property outputArtifactDetails The details of the output artifact of the action.
 * @property providerName The provider of the service used in the custom action
 * @property settings The settings for an action type.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property version The version identifier of the custom action.
 */
public data class CustomActionTypeArgs(
    public val category: Output<String>? = null,
    public val configurationProperties: Output<List<CustomActionTypeConfigurationPropertyArgs>>? =
        null,
    public val inputArtifactDetails: Output<CustomActionTypeInputArtifactDetailsArgs>? = null,
    public val outputArtifactDetails: Output<CustomActionTypeOutputArtifactDetailsArgs>? = null,
    public val providerName: Output<String>? = null,
    public val settings: Output<CustomActionTypeSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.CustomActionTypeArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.CustomActionTypeArgs =
        com.pulumi.aws.codepipeline.CustomActionTypeArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .configurationProperties(
                configurationProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inputArtifactDetails(
                inputArtifactDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputArtifactDetails(
                outputArtifactDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomActionTypeArgs].
 */
@PulumiTagMarker
public class CustomActionTypeArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var configurationProperties: Output<List<CustomActionTypeConfigurationPropertyArgs>>? =
        null

    private var inputArtifactDetails: Output<CustomActionTypeInputArtifactDetailsArgs>? = null

    private var outputArtifactDetails: Output<CustomActionTypeOutputArtifactDetailsArgs>? = null

    private var providerName: Output<String>? = null

    private var settings: Output<CustomActionTypeSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The category of the custom action. Valid values: `Source`, `Build`, `Deploy`, `Test`, `Invoke`, `Approval`
     */
    @JvmName("bqtvbhujetcftvdr")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("pmehugyckcvjxrpe")
    public suspend
    fun configurationProperties(`value`: Output<List<CustomActionTypeConfigurationPropertyArgs>>) {
        this.configurationProperties = value
    }

    @JvmName("rvjtfegtkhavrhyj")
    public suspend fun configurationProperties(
        vararg
        values: Output<CustomActionTypeConfigurationPropertyArgs>,
    ) {
        this.configurationProperties = Output.all(values.asList())
    }

    /**
     * @param values The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("rmgctjaylnllirgu")
    public suspend
    fun configurationProperties(values: List<Output<CustomActionTypeConfigurationPropertyArgs>>) {
        this.configurationProperties = Output.all(values)
    }

    /**
     * @param value The details of the input artifact for the action.
     */
    @JvmName("jcsdqjhjsrlxdkhj")
    public suspend
    fun inputArtifactDetails(`value`: Output<CustomActionTypeInputArtifactDetailsArgs>) {
        this.inputArtifactDetails = value
    }

    /**
     * @param value The details of the output artifact of the action.
     */
    @JvmName("hxqorbwynvtqtbef")
    public suspend
    fun outputArtifactDetails(`value`: Output<CustomActionTypeOutputArtifactDetailsArgs>) {
        this.outputArtifactDetails = value
    }

    /**
     * @param value The provider of the service used in the custom action
     */
    @JvmName("cqosyhuhitfcolti")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The settings for an action type.
     */
    @JvmName("gwhhkbphpvkkpove")
    public suspend fun settings(`value`: Output<CustomActionTypeSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("udhbebmulreriauv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The version identifier of the custom action.
     */
    @JvmName("rhmxotdqjwnaoywo")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The category of the custom action. Valid values: `Source`, `Build`, `Deploy`, `Test`, `Invoke`, `Approval`
     */
    @JvmName("srqfjrvjetoawtil")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("vunwpjqdudexbhst")
    public suspend
    fun configurationProperties(`value`: List<CustomActionTypeConfigurationPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProperties = mapped
    }

    /**
     * @param argument The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("pmstsoevvrblwbbs")
    public suspend
    fun configurationProperties(argument: List<suspend CustomActionTypeConfigurationPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomActionTypeConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationProperties = mapped
    }

    /**
     * @param argument The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("wylqscxburnumrsj")
    public suspend fun configurationProperties(
        vararg
        argument: suspend CustomActionTypeConfigurationPropertyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomActionTypeConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationProperties = mapped
    }

    /**
     * @param argument The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("fjcfpebrqnymfgle")
    public suspend
    fun configurationProperties(argument: suspend CustomActionTypeConfigurationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomActionTypeConfigurationPropertyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurationProperties = mapped
    }

    /**
     * @param values The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("lyvqugddmsywferm")
    public suspend fun configurationProperties(
        vararg
        values: CustomActionTypeConfigurationPropertyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationProperties = mapped
    }

    /**
     * @param value The details of the input artifact for the action.
     */
    @JvmName("regcoajhmypkdpxq")
    public suspend fun inputArtifactDetails(`value`: CustomActionTypeInputArtifactDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputArtifactDetails = mapped
    }

    /**
     * @param argument The details of the input artifact for the action.
     */
    @JvmName("iessfgngqovwfwme")
    public suspend
    fun inputArtifactDetails(argument: suspend CustomActionTypeInputArtifactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomActionTypeInputArtifactDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inputArtifactDetails = mapped
    }

    /**
     * @param value The details of the output artifact of the action.
     */
    @JvmName("unbuwnjufdioqeuh")
    public suspend fun outputArtifactDetails(`value`: CustomActionTypeOutputArtifactDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputArtifactDetails = mapped
    }

    /**
     * @param argument The details of the output artifact of the action.
     */
    @JvmName("xtetwtwxljvfnkfv")
    public suspend
    fun outputArtifactDetails(argument: suspend CustomActionTypeOutputArtifactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomActionTypeOutputArtifactDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outputArtifactDetails = mapped
    }

    /**
     * @param value The provider of the service used in the custom action
     */
    @JvmName("vxosuawxrrdpwcwx")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The settings for an action type.
     */
    @JvmName("pfodalxnynswrglx")
    public suspend fun settings(`value`: CustomActionTypeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument The settings for an action type.
     */
    @JvmName("hbngbwasfergunwr")
    public suspend fun settings(argument: suspend CustomActionTypeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomActionTypeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vtpwcfjxtpsnsjir")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("itcjvxkhiqfgmbjf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The version identifier of the custom action.
     */
    @JvmName("dbprtqfhjusofsja")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): CustomActionTypeArgs = CustomActionTypeArgs(
        category = category,
        configurationProperties = configurationProperties,
        inputArtifactDetails = inputArtifactDetails,
        outputArtifactDetails = outputArtifactDetails,
        providerName = providerName,
        settings = settings,
        tags = tags,
        version = version,
    )
}
