@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.kotlin.outputs.PipelineArtifactStore
import com.pulumi.aws.codepipeline.kotlin.outputs.PipelineStage
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codepipeline.kotlin.outputs.PipelineArtifactStore.Companion.toKotlin as pipelineArtifactStoreToKotlin
import com.pulumi.aws.codepipeline.kotlin.outputs.PipelineStage.Companion.toKotlin as pipelineStageToKotlin

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource = com.pulumi.aws.codepipeline.Pipeline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pipeline(builtJavaResource)
    }
}

/**
 * Provides a CodePipeline.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codestarconnections.Connection;
 * import com.pulumi.aws.codestarconnections.ConnectionArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kms.KmsFunctions;
 * import com.pulumi.aws.kms.inputs.GetAliasArgs;
 * import com.pulumi.aws.codepipeline.Pipeline;
 * import com.pulumi.aws.codepipeline.PipelineArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreEncryptionKeyArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineStageArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .providerType("GitHub")
 *             .build());
 *         var codepipelineBucket = new BucketV2("codepipelineBucket");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codepipeline.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var codepipelineRole = new Role("codepipelineRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var s3kmskey = KmsFunctions.getAlias(GetAliasArgs.builder()
 *             .name("alias/myKmsKey")
 *             .build());
 *         var codepipeline = new Pipeline("codepipeline", PipelineArgs.builder()
 *             .roleArn(codepipelineRole.arn())
 *             .artifactStores(PipelineArtifactStoreArgs.builder()
 *                 .location(codepipelineBucket.bucket())
 *                 .type("S3")
 *                 .encryptionKey(PipelineArtifactStoreEncryptionKeyArgs.builder()
 *                     .id(s3kmskey.applyValue(getAliasResult -> getAliasResult.arn()))
 *                     .type("KMS")
 *                     .build())
 *                 .build())
 *             .stages(
 *                 PipelineStageArgs.builder()
 *                     .name("Source")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Source")
 *                         .category("Source")
 *                         .owner("AWS")
 *                         .provider("CodeStarSourceConnection")
 *                         .version("1")
 *                         .outputArtifacts("source_output")
 *                         .configuration(Map.ofEntries(
 *                             Map.entry("ConnectionArn", example.arn()),
 *                             Map.entry("FullRepositoryId", "my-organization/example"),
 *                             Map.entry("BranchName", "main")
 *                         ))
 *                         .build())
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .name("Build")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Build")
 *                         .category("Build")
 *                         .owner("AWS")
 *                         .provider("CodeBuild")
 *                         .inputArtifacts("source_output")
 *                         .outputArtifacts("build_output")
 *                         .version("1")
 *                         .configuration(Map.of("ProjectName", "test"))
 *                         .build())
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .name("Deploy")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Deploy")
 *                         .category("Deploy")
 *                         .owner("AWS")
 *                         .provider("CloudFormation")
 *                         .inputArtifacts("build_output")
 *                         .version("1")
 *                         .configuration(Map.ofEntries(
 *                             Map.entry("ActionMode", "REPLACE_ON_FAILURE"),
 *                             Map.entry("Capabilities", "CAPABILITY_AUTO_EXPAND,CAPABILITY_IAM"),
 *                             Map.entry("OutputFileName", "CreateStackOutput.json"),
 *                             Map.entry("StackName", "MyStack"),
 *                             Map.entry("TemplatePath", "build_output::sam-templated.yaml")
 *                         ))
 *                         .build())
 *                     .build())
 *             .build());
 *         var codepipelineBucketAcl = new BucketAclV2("codepipelineBucketAcl", BucketAclV2Args.builder()
 *             .bucket(codepipelineBucket.id())
 *             .acl("private")
 *             .build());
 *         final var codepipelinePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetObject",
 *                         "s3:GetObjectVersion",
 *                         "s3:GetBucketVersioning",
 *                         "s3:PutObjectAcl",
 *                         "s3:PutObject")
 *                     .resources(
 *                         codepipelineBucket.arn(),
 *                         codepipelineBucket.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("codestar-connections:UseConnection")
 *                     .resources(example.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "codebuild:BatchGetBuilds",
 *                         "codebuild:StartBuild")
 *                     .resources("*")
 *                     .build())
 *             .build());
 *         var codepipelinePolicyRolePolicy = new RolePolicy("codepipelinePolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(codepipelineRole.id())
 *             .policy(codepipelinePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(codepipelinePolicyPolicyDocument -> codepipelinePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodePipelines using the name. For example:
 * ```sh
 *  $ pulumi import aws:codepipeline/pipeline:Pipeline foo example
 * ```
 * */
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.aws.codepipeline.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * The codepipeline ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * One or more artifact_store blocks. Artifact stores are documented below.
     */
    public val artifactStores: Output<List<PipelineArtifactStore>>
        get() = javaResource.artifactStores().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelineArtifactStoreToKotlin(args0) })
            })
        })

    /**
     * The name of the pipeline.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A stage block. Stages are documented below.
     */
    public val stages: Output<List<PipelineStage>>
        get() = javaResource.stages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineStageToKotlin(args0)
                })
            })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codepipeline.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.aws.codepipeline.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit):
    Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
