@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.PipelineArgs.builder
import com.pulumi.aws.codepipeline.kotlin.inputs.PipelineArtifactStoreArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.PipelineArtifactStoreArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.PipelineStageArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.PipelineStageArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodePipeline.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codestarconnections.Connection;
 * import com.pulumi.aws.codestarconnections.ConnectionArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kms.KmsFunctions;
 * import com.pulumi.aws.kms.inputs.GetAliasArgs;
 * import com.pulumi.aws.codepipeline.Pipeline;
 * import com.pulumi.aws.codepipeline.PipelineArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreEncryptionKeyArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineStageArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .providerType("GitHub")
 *             .build());
 *         var codepipelineBucket = new BucketV2("codepipelineBucket");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codepipeline.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var codepipelineRole = new Role("codepipelineRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var s3kmskey = KmsFunctions.getAlias(GetAliasArgs.builder()
 *             .name("alias/myKmsKey")
 *             .build());
 *         var codepipeline = new Pipeline("codepipeline", PipelineArgs.builder()
 *             .roleArn(codepipelineRole.arn())
 *             .artifactStores(PipelineArtifactStoreArgs.builder()
 *                 .location(codepipelineBucket.bucket())
 *                 .type("S3")
 *                 .encryptionKey(PipelineArtifactStoreEncryptionKeyArgs.builder()
 *                     .id(s3kmskey.applyValue(getAliasResult -> getAliasResult.arn()))
 *                     .type("KMS")
 *                     .build())
 *                 .build())
 *             .stages(
 *                 PipelineStageArgs.builder()
 *                     .name("Source")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Source")
 *                         .category("Source")
 *                         .owner("AWS")
 *                         .provider("CodeStarSourceConnection")
 *                         .version("1")
 *                         .outputArtifacts("source_output")
 *                         .configuration(Map.ofEntries(
 *                             Map.entry("ConnectionArn", example.arn()),
 *                             Map.entry("FullRepositoryId", "my-organization/example"),
 *                             Map.entry("BranchName", "main")
 *                         ))
 *                         .build())
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .name("Build")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Build")
 *                         .category("Build")
 *                         .owner("AWS")
 *                         .provider("CodeBuild")
 *                         .inputArtifacts("source_output")
 *                         .outputArtifacts("build_output")
 *                         .version("1")
 *                         .configuration(Map.of("ProjectName", "test"))
 *                         .build())
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .name("Deploy")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Deploy")
 *                         .category("Deploy")
 *                         .owner("AWS")
 *                         .provider("CloudFormation")
 *                         .inputArtifacts("build_output")
 *                         .version("1")
 *                         .configuration(Map.ofEntries(
 *                             Map.entry("ActionMode", "REPLACE_ON_FAILURE"),
 *                             Map.entry("Capabilities", "CAPABILITY_AUTO_EXPAND,CAPABILITY_IAM"),
 *                             Map.entry("OutputFileName", "CreateStackOutput.json"),
 *                             Map.entry("StackName", "MyStack"),
 *                             Map.entry("TemplatePath", "build_output::sam-templated.yaml")
 *                         ))
 *                         .build())
 *                     .build())
 *             .build());
 *         var codepipelineBucketAcl = new BucketAclV2("codepipelineBucketAcl", BucketAclV2Args.builder()
 *             .bucket(codepipelineBucket.id())
 *             .acl("private")
 *             .build());
 *         final var codepipelinePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "s3:GetObject",
 *                         "s3:GetObjectVersion",
 *                         "s3:GetBucketVersioning",
 *                         "s3:PutObjectAcl",
 *                         "s3:PutObject")
 *                     .resources(
 *                         codepipelineBucket.arn(),
 *                         codepipelineBucket.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("codestar-connections:UseConnection")
 *                     .resources(example.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "codebuild:BatchGetBuilds",
 *                         "codebuild:StartBuild")
 *                     .resources("*")
 *                     .build())
 *             .build());
 *         var codepipelinePolicyRolePolicy = new RolePolicy("codepipelinePolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(codepipelineRole.id())
 *             .policy(codepipelinePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(codepipelinePolicyPolicyDocument -> codepipelinePolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodePipelines using the name. For example:
 * ```sh
 *  $ pulumi import aws:codepipeline/pipeline:Pipeline foo example
 * ```
 * @property artifactStores One or more artifact_store blocks. Artifact stores are documented below.
 * @property name The name of the pipeline.
 * @property roleArn A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
 * @property stages A stage block. Stages are documented below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */
 */
public data class PipelineArgs(
    public val artifactStores: Output<List<PipelineArtifactStoreArgs>>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val stages: Output<List<PipelineStageArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.PipelineArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.PipelineArgs =
        com.pulumi.aws.codepipeline.PipelineArgs.builder()
            .artifactStores(
                artifactStores?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .stages(stages?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var artifactStores: Output<List<PipelineArtifactStoreArgs>>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var stages: Output<List<PipelineStageArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value One or more artifact_store blocks. Artifact stores are documented below.
     */
    @JvmName("ddeandlysbwatwyg")
    public suspend fun artifactStores(`value`: Output<List<PipelineArtifactStoreArgs>>) {
        this.artifactStores = value
    }

    @JvmName("ugdcwnvevnyakntk")
    public suspend fun artifactStores(vararg values: Output<PipelineArtifactStoreArgs>) {
        this.artifactStores = Output.all(values.asList())
    }

    /**
     * @param values One or more artifact_store blocks. Artifact stores are documented below.
     */
    @JvmName("rcnytckixphhufyv")
    public suspend fun artifactStores(values: List<Output<PipelineArtifactStoreArgs>>) {
        this.artifactStores = Output.all(values)
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("hlqdnvinuibtdwme")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
     */
    @JvmName("dsbxrxjhmsqtlmiv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A stage block. Stages are documented below.
     */
    @JvmName("kmjkpoybqxunfkpq")
    public suspend fun stages(`value`: Output<List<PipelineStageArgs>>) {
        this.stages = value
    }

    @JvmName("efsxrkpdejqjjlwv")
    public suspend fun stages(vararg values: Output<PipelineStageArgs>) {
        this.stages = Output.all(values.asList())
    }

    /**
     * @param values A stage block. Stages are documented below.
     */
    @JvmName("dmvqtjpnvkepywaj")
    public suspend fun stages(values: List<Output<PipelineStageArgs>>) {
        this.stages = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lhjfnqxxpbomrugc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value One or more artifact_store blocks. Artifact stores are documented below.
     */
    @JvmName("hhgqalvfxcvqkcfb")
    public suspend fun artifactStores(`value`: List<PipelineArtifactStoreArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStores = mapped
    }

    /**
     * @param argument One or more artifact_store blocks. Artifact stores are documented below.
     */
    @JvmName("ssgmuvipgmrwifpk")
    public suspend
    fun artifactStores(argument: List<suspend PipelineArtifactStoreArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineArtifactStoreArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifactStores = mapped
    }

    /**
     * @param argument One or more artifact_store blocks. Artifact stores are documented below.
     */
    @JvmName("utjlwvxvvxfkdgdd")
    public suspend fun artifactStores(
        vararg
        argument: suspend PipelineArtifactStoreArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipelineArtifactStoreArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifactStores = mapped
    }

    /**
     * @param argument One or more artifact_store blocks. Artifact stores are documented below.
     */
    @JvmName("stsedtkxxecxpsvu")
    public suspend fun artifactStores(argument: suspend PipelineArtifactStoreArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PipelineArtifactStoreArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.artifactStores = mapped
    }

    /**
     * @param values One or more artifact_store blocks. Artifact stores are documented below.
     */
    @JvmName("nqjaghuvptsbckhk")
    public suspend fun artifactStores(vararg values: PipelineArtifactStoreArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactStores = mapped
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("mrjxcisibsqaedop")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
     */
    @JvmName("gnxvyywhqtxkyhrw")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A stage block. Stages are documented below.
     */
    @JvmName("hkwhxdlyucfhhrco")
    public suspend fun stages(`value`: List<PipelineStageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param argument A stage block. Stages are documented below.
     */
    @JvmName("wjkahfaqkploxxux")
    public suspend fun stages(argument: List<suspend PipelineStageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineStageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument A stage block. Stages are documented below.
     */
    @JvmName("jsyrqqxensyrirex")
    public suspend fun stages(vararg argument: suspend PipelineStageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineStageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument A stage block. Stages are documented below.
     */
    @JvmName("jjljxpmwheilpvno")
    public suspend fun stages(argument: suspend PipelineStageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PipelineStageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param values A stage block. Stages are documented below.
     */
    @JvmName("mjrgrovjmviywwot")
    public suspend fun stages(vararg values: PipelineStageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("emshjpmlalayalob")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mmfemleiidupkgga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        artifactStores = artifactStores,
        name = name,
        roleArn = roleArn,
        stages = stages,
        tags = tags,
    )
}
