@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.WebhookArgs.builder
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookAuthenticationConfigurationArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookAuthenticationConfigurationArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookFilterArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookFilterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodePipeline Webhook.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codepipeline.Pipeline;
 * import com.pulumi.aws.codepipeline.PipelineArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreEncryptionKeyArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineStageArgs;
 * import com.pulumi.aws.codepipeline.Webhook;
 * import com.pulumi.aws.codepipeline.WebhookArgs;
 * import com.pulumi.aws.codepipeline.inputs.WebhookAuthenticationConfigurationArgs;
 * import com.pulumi.aws.codepipeline.inputs.WebhookFilterArgs;
 * import com.pulumi.github.RepositoryWebhook;
 * import com.pulumi.github.RepositoryWebhookArgs;
 * import com.pulumi.github.inputs.RepositoryWebhookConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var barPipeline = new Pipeline("barPipeline", PipelineArgs.builder()
 *             .roleArn(aws_iam_role.bar().arn())
 *             .artifactStores(PipelineArtifactStoreArgs.builder()
 *                 .location(aws_s3_bucket.bar().bucket())
 *                 .type("S3")
 *                 .encryptionKey(PipelineArtifactStoreEncryptionKeyArgs.builder()
 *                     .id(data.aws_kms_alias().s3kmskey().arn())
 *                     .type("KMS")
 *                     .build())
 *                 .build())
 *             .stages(
 *                 PipelineStageArgs.builder()
 *                     .name("Source")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Source")
 *                         .category("Source")
 *                         .owner("ThirdParty")
 *                         .provider("GitHub")
 *                         .version("1")
 *                         .outputArtifacts("test")
 *                         .configuration(Map.ofEntries(
 *                             Map.entry("Owner", "my-organization"),
 *                             Map.entry("Repo", "test"),
 *                             Map.entry("Branch", "master")
 *                         ))
 *                         .build())
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .name("Build")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Build")
 *                         .category("Build")
 *                         .owner("AWS")
 *                         .provider("CodeBuild")
 *                         .inputArtifacts("test")
 *                         .version("1")
 *                         .configuration(Map.of("ProjectName", "test"))
 *                         .build())
 *                     .build())
 *             .build());
 *         final var webhookSecret = "super-secret";
 *         var barWebhook = new Webhook("barWebhook", WebhookArgs.builder()
 *             .authentication("GITHUB_HMAC")
 *             .targetAction("Source")
 *             .targetPipeline(barPipeline.name())
 *             .authenticationConfiguration(WebhookAuthenticationConfigurationArgs.builder()
 *                 .secretToken(webhookSecret)
 *                 .build())
 *             .filters(WebhookFilterArgs.builder()
 *                 .jsonPath("$.ref")
 *                 .matchEquals("refs/heads/{Branch}")
 *                 .build())
 *             .build());
 *         var barRepositoryWebhook = new RepositoryWebhook("barRepositoryWebhook", RepositoryWebhookArgs.builder()
 *             .repository(github_repository.repo().name())
 *             .configuration(RepositoryWebhookConfigurationArgs.builder()
 *                 .url(barWebhook.url())
 *                 .contentType("json")
 *                 .insecureSsl(true)
 *                 .secret(webhookSecret)
 *                 .build())
 *             .events("push")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodePipeline Webhooks using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:codepipeline/webhook:Webhook example arn:aws:codepipeline:us-west-2:123456789012:webhook:example
 * ```
 * @property authentication The type of authentication  to use. One of `IP`, `GITHUB_HMAC`, or `UNAUTHENTICATED`.
 * @property authenticationConfiguration An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
 * @property filters One or more `filter` blocks. Filter blocks are documented below.
 * @property name The name of the webhook.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetAction The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.
 * @property targetPipeline The name of the pipeline.
 */
public data class WebhookArgs(
    public val authentication: Output<String>? = null,
    public val authenticationConfiguration: Output<WebhookAuthenticationConfigurationArgs>? = null,
    public val filters: Output<List<WebhookFilterArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetAction: Output<String>? = null,
    public val targetPipeline: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.WebhookArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.WebhookArgs =
        com.pulumi.aws.codepipeline.WebhookArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .authenticationConfiguration(
                authenticationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetAction(targetAction?.applyValue({ args0 -> args0 }))
            .targetPipeline(targetPipeline?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var authentication: Output<String>? = null

    private var authenticationConfiguration: Output<WebhookAuthenticationConfigurationArgs>? = null

    private var filters: Output<List<WebhookFilterArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetAction: Output<String>? = null

    private var targetPipeline: Output<String>? = null

    /**
     * @param value The type of authentication  to use. One of `IP`, `GITHUB_HMAC`, or `UNAUTHENTICATED`.
     */
    @JvmName("odbvamoyegxskubl")
    public suspend fun authentication(`value`: Output<String>) {
        this.authentication = value
    }

    /**
     * @param value An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
     */
    @JvmName("qosvypkbfhpmbfhy")
    public suspend
    fun authenticationConfiguration(`value`: Output<WebhookAuthenticationConfigurationArgs>) {
        this.authenticationConfiguration = value
    }

    /**
     * @param value One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("jdaofmcqisyvsrhv")
    public suspend fun filters(`value`: Output<List<WebhookFilterArgs>>) {
        this.filters = value
    }

    @JvmName("sgmbjktuqvvossdc")
    public suspend fun filters(vararg values: Output<WebhookFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("vbnqfgbyhahirwtk")
    public suspend fun filters(values: List<Output<WebhookFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("tqsvdubdwguwuhfk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mjdvpuagwrtpanwy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.
     */
    @JvmName("lnjtdjmgfaqrumoi")
    public suspend fun targetAction(`value`: Output<String>) {
        this.targetAction = value
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("mbvdwvavwclyfcxj")
    public suspend fun targetPipeline(`value`: Output<String>) {
        this.targetPipeline = value
    }

    /**
     * @param value The type of authentication  to use. One of `IP`, `GITHUB_HMAC`, or `UNAUTHENTICATED`.
     */
    @JvmName("vmneweubxeseehds")
    public suspend fun authentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
     */
    @JvmName("yrsmnsoyfjtjoflo")
    public suspend fun authenticationConfiguration(`value`: WebhookAuthenticationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationConfiguration = mapped
    }

    /**
     * @param argument An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
     */
    @JvmName("agxupmhuapkbkvwd")
    public suspend
    fun authenticationConfiguration(argument: suspend WebhookAuthenticationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WebhookAuthenticationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticationConfiguration = mapped
    }

    /**
     * @param value One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("cbndphmrtpeimrha")
    public suspend fun filters(`value`: List<WebhookFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("soqvsaodgqdcrjlt")
    public suspend fun filters(argument: List<suspend WebhookFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("jigwwotvhgjjomhh")
    public suspend fun filters(vararg argument: suspend WebhookFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebhookFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("lmmuwnvlsgmpmxjy")
    public suspend fun filters(argument: suspend WebhookFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("xktxmgktcpepsffq")
    public suspend fun filters(vararg values: WebhookFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("gjmkcdgeocmttxay")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eveikxraufiljymt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pdqobtkqccqvowvr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.
     */
    @JvmName("ipkyhhrnjlbayfhi")
    public suspend fun targetAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAction = mapped
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("buyfjpkkhgkihaqi")
    public suspend fun targetPipeline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPipeline = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        authentication = authentication,
        authenticationConfiguration = authenticationConfiguration,
        filters = filters,
        name = name,
        tags = tags,
        targetAction = targetAction,
        targetPipeline = targetPipeline,
    )
}
