@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.CustomActionTypeConfigurationPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the action configuration property.
 * @property key Whether the configuration property is a key.
 * @property name The name of the action configuration property.
 * @property queryable Indicates that the property will be used in conjunction with PollForJobs.
 * @property required Whether the configuration property is a required value.
 * @property secret Whether the configuration property is secret.
 * @property type The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
 */
public data class CustomActionTypeConfigurationPropertyArgs(
    public val description: Output<String>? = null,
    public val key: Output<Boolean>,
    public val name: Output<String>,
    public val queryable: Output<Boolean>? = null,
    public val required: Output<Boolean>,
    public val secret: Output<Boolean>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.CustomActionTypeConfigurationPropertyArgs> {
    override fun toJava():
        com.pulumi.aws.codepipeline.inputs.CustomActionTypeConfigurationPropertyArgs =
        com.pulumi.aws.codepipeline.inputs.CustomActionTypeConfigurationPropertyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .queryable(queryable?.applyValue({ args0 -> args0 }))
            .required(required.applyValue({ args0 -> args0 }))
            .secret(secret.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomActionTypeConfigurationPropertyArgs].
 */
@PulumiTagMarker
public class CustomActionTypeConfigurationPropertyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var key: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var queryable: Output<Boolean>? = null

    private var required: Output<Boolean>? = null

    private var secret: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value The description of the action configuration property.
     */
    @JvmName("rsdmdnatdsgpxshu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the configuration property is a key.
     */
    @JvmName("wmmjtmgksyqmegop")
    public suspend fun key(`value`: Output<Boolean>) {
        this.key = value
    }

    /**
     * @param value The name of the action configuration property.
     */
    @JvmName("ueuthywfwkjdimns")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates that the property will be used in conjunction with PollForJobs.
     */
    @JvmName("bigfahckhdrrsfvx")
    public suspend fun queryable(`value`: Output<Boolean>) {
        this.queryable = value
    }

    /**
     * @param value Whether the configuration property is a required value.
     */
    @JvmName("cgnwcdrhhffgxuax")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Whether the configuration property is secret.
     */
    @JvmName("ijkqmjbnpnaonpsi")
    public suspend fun secret(`value`: Output<Boolean>) {
        this.secret = value
    }

    /**
     * @param value The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
     */
    @JvmName("phmfpexokvukxllw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The description of the action configuration property.
     */
    @JvmName("mfodlftidoouvjjv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the configuration property is a key.
     */
    @JvmName("pbwmxhnudiiccnhl")
    public suspend fun key(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The name of the action configuration property.
     */
    @JvmName("yrufsggbmhqulygx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates that the property will be used in conjunction with PollForJobs.
     */
    @JvmName("ecyfkgtpjuegdijb")
    public suspend fun queryable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryable = mapped
    }

    /**
     * @param value Whether the configuration property is a required value.
     */
    @JvmName("sfvsydidjkiliblx")
    public suspend fun required(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.required = mapped
    }

    /**
     * @param value Whether the configuration property is secret.
     */
    @JvmName("pebfvftduhwrhfjp")
    public suspend fun secret(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param value The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
     */
    @JvmName("rcuucywfbyhfvncc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CustomActionTypeConfigurationPropertyArgs =
        CustomActionTypeConfigurationPropertyArgs(
            description = description,
            key = key ?: throw PulumiNullFieldException("key"),
            name = name ?: throw PulumiNullFieldException("name"),
            queryable = queryable,
            required = required ?: throw PulumiNullFieldException("required"),
            secret = secret ?: throw PulumiNullFieldException("secret"),
            type = type,
        )
}
