@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.CustomActionTypeInputArtifactDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumCount The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
 * @property minimumCount The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
 */
public data class CustomActionTypeInputArtifactDetailsArgs(
    public val maximumCount: Output<Int>,
    public val minimumCount: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.CustomActionTypeInputArtifactDetailsArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.CustomActionTypeInputArtifactDetailsArgs =
        com.pulumi.aws.codepipeline.inputs.CustomActionTypeInputArtifactDetailsArgs.builder()
            .maximumCount(maximumCount.applyValue({ args0 -> args0 }))
            .minimumCount(minimumCount.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomActionTypeInputArtifactDetailsArgs].
 */
@PulumiTagMarker
public class CustomActionTypeInputArtifactDetailsArgsBuilder internal constructor() {
    private var maximumCount: Output<Int>? = null

    private var minimumCount: Output<Int>? = null

    /**
     * @param value The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("sjqfombooyqcwcgo")
    public suspend fun maximumCount(`value`: Output<Int>) {
        this.maximumCount = value
    }

    /**
     * @param value The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("fykvepybuqtgjjuy")
    public suspend fun minimumCount(`value`: Output<Int>) {
        this.minimumCount = value
    }

    /**
     * @param value The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("grrfodicybunujyh")
    public suspend fun maximumCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumCount = mapped
    }

    /**
     * @param value The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("bepjhemdxyyvchpn")
    public suspend fun minimumCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumCount = mapped
    }

    internal fun build(): CustomActionTypeInputArtifactDetailsArgs =
        CustomActionTypeInputArtifactDetailsArgs(
            maximumCount = maximumCount ?: throw PulumiNullFieldException("maximumCount"),
            minimumCount = minimumCount ?: throw PulumiNullFieldException("minimumCount"),
        )
}
