@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.CustomActionTypeOutputArtifactDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumCount The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
 * @property minimumCount The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
 */
public data class CustomActionTypeOutputArtifactDetailsArgs(
    public val maximumCount: Output<Int>,
    public val minimumCount: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.CustomActionTypeOutputArtifactDetailsArgs> {
    override fun toJava():
        com.pulumi.aws.codepipeline.inputs.CustomActionTypeOutputArtifactDetailsArgs =
        com.pulumi.aws.codepipeline.inputs.CustomActionTypeOutputArtifactDetailsArgs.builder()
            .maximumCount(maximumCount.applyValue({ args0 -> args0 }))
            .minimumCount(minimumCount.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomActionTypeOutputArtifactDetailsArgs].
 */
@PulumiTagMarker
public class CustomActionTypeOutputArtifactDetailsArgsBuilder internal constructor() {
    private var maximumCount: Output<Int>? = null

    private var minimumCount: Output<Int>? = null

    /**
     * @param value The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("lptirddygdwstbdg")
    public suspend fun maximumCount(`value`: Output<Int>) {
        this.maximumCount = value
    }

    /**
     * @param value The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("fmsvyvibaieduisq")
    public suspend fun minimumCount(`value`: Output<Int>) {
        this.minimumCount = value
    }

    /**
     * @param value The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("fndmkwmyhvvtnkwq")
    public suspend fun maximumCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumCount = mapped
    }

    /**
     * @param value The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
     */
    @JvmName("cpjcmgfumpmsgcjd")
    public suspend fun minimumCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumCount = mapped
    }

    internal fun build(): CustomActionTypeOutputArtifactDetailsArgs =
        CustomActionTypeOutputArtifactDetailsArgs(
            maximumCount = maximumCount ?: throw PulumiNullFieldException("maximumCount"),
            minimumCount = minimumCount ?: throw PulumiNullFieldException("minimumCount"),
        )
}
