@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.CustomActionTypeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityUrlTemplate The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
 * @property executionUrlTemplate The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
 * @property revisionUrlTemplate The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
 * @property thirdPartyConfigurationUrl The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
 */
public data class CustomActionTypeSettingsArgs(
    public val entityUrlTemplate: Output<String>? = null,
    public val executionUrlTemplate: Output<String>? = null,
    public val revisionUrlTemplate: Output<String>? = null,
    public val thirdPartyConfigurationUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.CustomActionTypeSettingsArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.CustomActionTypeSettingsArgs =
        com.pulumi.aws.codepipeline.inputs.CustomActionTypeSettingsArgs.builder()
            .entityUrlTemplate(entityUrlTemplate?.applyValue({ args0 -> args0 }))
            .executionUrlTemplate(executionUrlTemplate?.applyValue({ args0 -> args0 }))
            .revisionUrlTemplate(revisionUrlTemplate?.applyValue({ args0 -> args0 }))
            .thirdPartyConfigurationUrl(thirdPartyConfigurationUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomActionTypeSettingsArgs].
 */
@PulumiTagMarker
public class CustomActionTypeSettingsArgsBuilder internal constructor() {
    private var entityUrlTemplate: Output<String>? = null

    private var executionUrlTemplate: Output<String>? = null

    private var revisionUrlTemplate: Output<String>? = null

    private var thirdPartyConfigurationUrl: Output<String>? = null

    /**
     * @param value The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
     */
    @JvmName("augdnnschhltwymr")
    public suspend fun entityUrlTemplate(`value`: Output<String>) {
        this.entityUrlTemplate = value
    }

    /**
     * @param value The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
     */
    @JvmName("eukpinlnlfqnotar")
    public suspend fun executionUrlTemplate(`value`: Output<String>) {
        this.executionUrlTemplate = value
    }

    /**
     * @param value The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
     */
    @JvmName("wvvdrldncsrkswgx")
    public suspend fun revisionUrlTemplate(`value`: Output<String>) {
        this.revisionUrlTemplate = value
    }

    /**
     * @param value The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
     */
    @JvmName("deqroohvxbokkopq")
    public suspend fun thirdPartyConfigurationUrl(`value`: Output<String>) {
        this.thirdPartyConfigurationUrl = value
    }

    /**
     * @param value The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
     */
    @JvmName("gtmftwbjlmkhpepv")
    public suspend fun entityUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityUrlTemplate = mapped
    }

    /**
     * @param value The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
     */
    @JvmName("mbbgrurrwomjxgcg")
    public suspend fun executionUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionUrlTemplate = mapped
    }

    /**
     * @param value The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
     */
    @JvmName("eguffaytirvaglds")
    public suspend fun revisionUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revisionUrlTemplate = mapped
    }

    /**
     * @param value The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
     */
    @JvmName("yspclldlkdlbioyk")
    public suspend fun thirdPartyConfigurationUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thirdPartyConfigurationUrl = mapped
    }

    internal fun build(): CustomActionTypeSettingsArgs = CustomActionTypeSettingsArgs(
        entityUrlTemplate = entityUrlTemplate,
        executionUrlTemplate = executionUrlTemplate,
        revisionUrlTemplate = revisionUrlTemplate,
        thirdPartyConfigurationUrl = thirdPartyConfigurationUrl,
    )
}
