@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionKey The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
 * @property location The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
 * @property region The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
 * @property type The type of the artifact store, such as Amazon S3
 */
public data class PipelineArtifactStoreArgs(
    public val encryptionKey: Output<PipelineArtifactStoreEncryptionKeyArgs>? = null,
    public val location: Output<String>,
    public val region: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs.builder()
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineArtifactStoreArgs].
 */
@PulumiTagMarker
public class PipelineArtifactStoreArgsBuilder internal constructor() {
    private var encryptionKey: Output<PipelineArtifactStoreEncryptionKeyArgs>? = null

    private var location: Output<String>? = null

    private var region: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
     */
    @JvmName("kgfqqpppubadnkqn")
    public suspend fun encryptionKey(`value`: Output<PipelineArtifactStoreEncryptionKeyArgs>) {
        this.encryptionKey = value
    }

    /**
     * @param value The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
     */
    @JvmName("rcovytylwymotrwh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
     */
    @JvmName("epxfcacjbbibtpom")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The type of the artifact store, such as Amazon S3
     */
    @JvmName("fkmhccvbbvxeaegq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
     */
    @JvmName("kbwxqnxkfcdqgjbu")
    public suspend fun encryptionKey(`value`: PipelineArtifactStoreEncryptionKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param argument The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
     */
    @JvmName("dswimctohrvevpxp")
    public suspend
    fun encryptionKey(argument: suspend PipelineArtifactStoreEncryptionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineArtifactStoreEncryptionKeyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionKey = mapped
    }

    /**
     * @param value The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
     */
    @JvmName("lvoohpvssrhuinmg")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
     */
    @JvmName("pgcvrntmojwpcmqf")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The type of the artifact store, such as Amazon S3
     */
    @JvmName("qmmhvpdfxtmdtrmk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineArtifactStoreArgs = PipelineArtifactStoreArgs(
        encryptionKey = encryptionKey,
        location = location ?: throw PulumiNullFieldException("location"),
        region = region,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
