@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineStageActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property category A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
 * @property configuration A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs&#46;aws&#46;amazon&#46;com/codepipeline/latest/userguide/reference-pipeline-structure&#46;html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
 * @property inputArtifacts A list of artifact names to be worked on.
 * @property name The action declaration's name.
 * @property namespace The namespace all output variables will be accessed from.
 * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
 * @property outputArtifacts A list of artifact names to output. Output artifact names must be unique within a pipeline.
 * @property owner The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
 * @property provider The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
 * @property region The region in which to run the action.
 * @property roleArn The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
 * @property runOrder The order in which actions are run.
 * @property version A string that identifies the action type.
 */
public data class PipelineStageActionArgs(
    public val category: Output<String>,
    public val configuration: Output<Map<String, String>>? = null,
    public val inputArtifacts: Output<List<String>>? = null,
    public val name: Output<String>,
    public val namespace: Output<String>? = null,
    public val outputArtifacts: Output<List<String>>? = null,
    public val owner: Output<String>,
    public val provider: Output<String>,
    public val region: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val runOrder: Output<Int>? = null,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineStageActionArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineStageActionArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineStageActionArgs.builder()
            .category(category.applyValue({ args0 -> args0 }))
            .configuration(
                configuration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .inputArtifacts(inputArtifacts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .outputArtifacts(outputArtifacts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .owner(owner.applyValue({ args0 -> args0 }))
            .provider(provider.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .runOrder(runOrder?.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineStageActionArgs].
 */
@PulumiTagMarker
public class PipelineStageActionArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var configuration: Output<Map<String, String>>? = null

    private var inputArtifacts: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    private var outputArtifacts: Output<List<String>>? = null

    private var owner: Output<String>? = null

    private var provider: Output<String>? = null

    private var region: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var runOrder: Output<Int>? = null

    private var version: Output<String>? = null

    /**
     * @param value A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
     */
    @JvmName("dfoirjlfmfgrwvxw")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs&#46;aws&#46;amazon&#46;com/codepipeline/latest/userguide/reference-pipeline-structure&#46;html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     */
    @JvmName("opcmskhdjveuwpxo")
    public suspend fun configuration(`value`: Output<Map<String, String>>) {
        this.configuration = value
    }

    /**
     * @param value A list of artifact names to be worked on.
     */
    @JvmName("hnjfvtucifuaajuu")
    public suspend fun inputArtifacts(`value`: Output<List<String>>) {
        this.inputArtifacts = value
    }

    @JvmName("reqjvturesqkiqtn")
    public suspend fun inputArtifacts(vararg values: Output<String>) {
        this.inputArtifacts = Output.all(values.asList())
    }

    /**
     * @param values A list of artifact names to be worked on.
     */
    @JvmName("nrsdsmpitlqkncsf")
    public suspend fun inputArtifacts(values: List<Output<String>>) {
        this.inputArtifacts = Output.all(values)
    }

    /**
     * @param value The action declaration's name.
     */
    @JvmName("rfxtmerqcjhlfgcj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The namespace all output variables will be accessed from.
     * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
     */
    @JvmName("dijfquaswimpiwrg")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value A list of artifact names to output. Output artifact names must be unique within a pipeline.
     */
    @JvmName("jpdupibwghifpkvl")
    public suspend fun outputArtifacts(`value`: Output<List<String>>) {
        this.outputArtifacts = value
    }

    @JvmName("vmtiomkmrewslxgy")
    public suspend fun outputArtifacts(vararg values: Output<String>) {
        this.outputArtifacts = Output.all(values.asList())
    }

    /**
     * @param values A list of artifact names to output. Output artifact names must be unique within a pipeline.
     */
    @JvmName("kwcxpakfxorukeqn")
    public suspend fun outputArtifacts(values: List<Output<String>>) {
        this.outputArtifacts = Output.all(values)
    }

    /**
     * @param value The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
     */
    @JvmName("bwoddpdivdadiwpq")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     */
    @JvmName("xjirgkdokmjjodfl")
    public suspend fun provider(`value`: Output<String>) {
        this.provider = value
    }

    /**
     * @param value The region in which to run the action.
     */
    @JvmName("ttfysryqkoypxqbk")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
     */
    @JvmName("ohtpmuceloipfqgj")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The order in which actions are run.
     */
    @JvmName("aeklwfdrblionkto")
    public suspend fun runOrder(`value`: Output<Int>) {
        this.runOrder = value
    }

    /**
     * @param value A string that identifies the action type.
     */
    @JvmName("imemepcmfscrjgpj")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
     */
    @JvmName("jvbgatyjrbyqjfxw")
    public suspend fun category(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs&#46;aws&#46;amazon&#46;com/codepipeline/latest/userguide/reference-pipeline-structure&#46;html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     */
    @JvmName("jqlisscaabctmqgc")
    public suspend fun configuration(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param values A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs&#46;aws&#46;amazon&#46;com/codepipeline/latest/userguide/reference-pipeline-structure&#46;html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     */
    @JvmName("gtikwptnfbjxtwys")
    public fun configuration(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value A list of artifact names to be worked on.
     */
    @JvmName("fdrqgdbqtedilioi")
    public suspend fun inputArtifacts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputArtifacts = mapped
    }

    /**
     * @param values A list of artifact names to be worked on.
     */
    @JvmName("wpnsitojriylluka")
    public suspend fun inputArtifacts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputArtifacts = mapped
    }

    /**
     * @param value The action declaration's name.
     */
    @JvmName("ypkneguefyjjhbiw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The namespace all output variables will be accessed from.
     * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
     */
    @JvmName("oqimjmlhwparvgwl")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value A list of artifact names to output. Output artifact names must be unique within a pipeline.
     */
    @JvmName("ivubhcvmidbtpdax")
    public suspend fun outputArtifacts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputArtifacts = mapped
    }

    /**
     * @param values A list of artifact names to output. Output artifact names must be unique within a pipeline.
     */
    @JvmName("wandrygaxcnpsmai")
    public suspend fun outputArtifacts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputArtifacts = mapped
    }

    /**
     * @param value The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
     */
    @JvmName("xqjsroicckomuoqv")
    public suspend fun owner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     */
    @JvmName("infebbfbnebevnhr")
    public suspend fun provider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value The region in which to run the action.
     */
    @JvmName("cunplpwyljgoiaoy")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
     */
    @JvmName("jidvspeejapoivit")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The order in which actions are run.
     */
    @JvmName("yibwvglxuupuunqk")
    public suspend fun runOrder(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runOrder = mapped
    }

    /**
     * @param value A string that identifies the action type.
     */
    @JvmName("uvdwugtmjteiikfb")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PipelineStageActionArgs = PipelineStageActionArgs(
        category = category ?: throw PulumiNullFieldException("category"),
        configuration = configuration,
        inputArtifacts = inputArtifacts,
        name = name ?: throw PulumiNullFieldException("name"),
        namespace = namespace,
        outputArtifacts = outputArtifacts,
        owner = owner ?: throw PulumiNullFieldException("owner"),
        provider = provider ?: throw PulumiNullFieldException("provider"),
        region = region,
        roleArn = roleArn,
        runOrder = runOrder,
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
