@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.WebhookAuthenticationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowedIpRange A valid CIDR block for `IP` filtering. Required for `IP`.
 * @property secretToken The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
 */
public data class WebhookAuthenticationConfigurationArgs(
    public val allowedIpRange: Output<String>? = null,
    public val secretToken: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.WebhookAuthenticationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.WebhookAuthenticationConfigurationArgs =
        com.pulumi.aws.codepipeline.inputs.WebhookAuthenticationConfigurationArgs.builder()
            .allowedIpRange(allowedIpRange?.applyValue({ args0 -> args0 }))
            .secretToken(secretToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookAuthenticationConfigurationArgs].
 */
@PulumiTagMarker
public class WebhookAuthenticationConfigurationArgsBuilder internal constructor() {
    private var allowedIpRange: Output<String>? = null

    private var secretToken: Output<String>? = null

    /**
     * @param value A valid CIDR block for `IP` filtering. Required for `IP`.
     */
    @JvmName("aqggfkduxqkrkube")
    public suspend fun allowedIpRange(`value`: Output<String>) {
        this.allowedIpRange = value
    }

    /**
     * @param value The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
     */
    @JvmName("wuxjvoxjeewbbpsr")
    public suspend fun secretToken(`value`: Output<String>) {
        this.secretToken = value
    }

    /**
     * @param value A valid CIDR block for `IP` filtering. Required for `IP`.
     */
    @JvmName("raobmhqsuxxqwpja")
    public suspend fun allowedIpRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedIpRange = mapped
    }

    /**
     * @param value The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
     */
    @JvmName("bniippcffnhqcmov")
    public suspend fun secretToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretToken = mapped
    }

    internal fun build(): WebhookAuthenticationConfigurationArgs =
        WebhookAuthenticationConfigurationArgs(
            allowedIpRange = allowedIpRange,
            secretToken = secretToken,
        )
}
