@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.WebhookFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jsonPath The [JSON path](https://github.com/json-path/JsonPath) to filter on.
 * @property matchEquals The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
 */
public data class WebhookFilterArgs(
    public val jsonPath: Output<String>,
    public val matchEquals: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.WebhookFilterArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.WebhookFilterArgs =
        com.pulumi.aws.codepipeline.inputs.WebhookFilterArgs.builder()
            .jsonPath(jsonPath.applyValue({ args0 -> args0 }))
            .matchEquals(matchEquals.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookFilterArgs].
 */
@PulumiTagMarker
public class WebhookFilterArgsBuilder internal constructor() {
    private var jsonPath: Output<String>? = null

    private var matchEquals: Output<String>? = null

    /**
     * @param value The [JSON path](https://github.com/json-path/JsonPath) to filter on.
     */
    @JvmName("cfvjixwbyegquliu")
    public suspend fun jsonPath(`value`: Output<String>) {
        this.jsonPath = value
    }

    /**
     * @param value The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
     */
    @JvmName("akuxoobaqxsiymse")
    public suspend fun matchEquals(`value`: Output<String>) {
        this.matchEquals = value
    }

    /**
     * @param value The [JSON path](https://github.com/json-path/JsonPath) to filter on.
     */
    @JvmName("nmrblphxesifynyr")
    public suspend fun jsonPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jsonPath = mapped
    }

    /**
     * @param value The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
     */
    @JvmName("jxkhqscmlmrxrqrr")
    public suspend fun matchEquals(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchEquals = mapped
    }

    internal fun build(): WebhookFilterArgs = WebhookFilterArgs(
        jsonPath = jsonPath ?: throw PulumiNullFieldException("jsonPath"),
        matchEquals = matchEquals ?: throw PulumiNullFieldException("matchEquals"),
    )
}
