@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumCount The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
 * @property minimumCount The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
 */
public data class CustomActionTypeInputArtifactDetails(
    public val maximumCount: Int,
    public val minimumCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.CustomActionTypeInputArtifactDetails):
            CustomActionTypeInputArtifactDetails = CustomActionTypeInputArtifactDetails(
            maximumCount = javaType.maximumCount(),
            minimumCount = javaType.minimumCount(),
        )
    }
}
