@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property entityUrlTemplate The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
 * @property executionUrlTemplate The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
 * @property revisionUrlTemplate The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
 * @property thirdPartyConfigurationUrl The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
 */
public data class CustomActionTypeSettings(
    public val entityUrlTemplate: String? = null,
    public val executionUrlTemplate: String? = null,
    public val revisionUrlTemplate: String? = null,
    public val thirdPartyConfigurationUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.CustomActionTypeSettings):
            CustomActionTypeSettings = CustomActionTypeSettings(
            entityUrlTemplate = javaType.entityUrlTemplate().map({ args0 -> args0 }).orElse(null),
            executionUrlTemplate = javaType.executionUrlTemplate().map({ args0 -> args0 }).orElse(null),
            revisionUrlTemplate = javaType.revisionUrlTemplate().map({ args0 -> args0 }).orElse(null),
            thirdPartyConfigurationUrl = javaType.thirdPartyConfigurationUrl().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
