@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionKey The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
 * @property location The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
 * @property region The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
 * @property type The type of the artifact store, such as Amazon S3
 */
public data class PipelineArtifactStore(
    public val encryptionKey: PipelineArtifactStoreEncryptionKey? = null,
    public val location: String,
    public val region: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineArtifactStore):
            PipelineArtifactStore = PipelineArtifactStore(
            encryptionKey = javaType.encryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineArtifactStoreEncryptionKey.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
