@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions The action(s) to include in the stage. Defined as an `action` block below
 * @property name The name of the stage.
 */
public data class PipelineStage(
    public val actions: List<PipelineStageAction>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineStage): PipelineStage =
            PipelineStage(
                actions = javaType.actions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.codepipeline.kotlin.outputs.PipelineStageAction.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
            )
    }
}
