@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property category A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
 * @property configuration A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs&#46;aws&#46;amazon&#46;com/codepipeline/latest/userguide/reference-pipeline-structure&#46;html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
 * @property inputArtifacts A list of artifact names to be worked on.
 * @property name The action declaration's name.
 * @property namespace The namespace all output variables will be accessed from.
 * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
 * @property outputArtifacts A list of artifact names to output. Output artifact names must be unique within a pipeline.
 * @property owner The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
 * @property provider The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
 * @property region The region in which to run the action.
 * @property roleArn The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
 * @property runOrder The order in which actions are run.
 * @property version A string that identifies the action type.
 */
public data class PipelineStageAction(
    public val category: String,
    public val configuration: Map<String, String>? = null,
    public val inputArtifacts: List<String>? = null,
    public val name: String,
    public val namespace: String? = null,
    public val outputArtifacts: List<String>? = null,
    public val owner: String,
    public val provider: String,
    public val region: String? = null,
    public val roleArn: String? = null,
    public val runOrder: Int? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineStageAction):
            PipelineStageAction = PipelineStageAction(
            category = javaType.category(),
            configuration = javaType.configuration().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            inputArtifacts = javaType.inputArtifacts().map({ args0 -> args0 }),
            name = javaType.name(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            outputArtifacts = javaType.outputArtifacts().map({ args0 -> args0 }),
            owner = javaType.owner(),
            provider = javaType.provider(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            runOrder = javaType.runOrder().map({ args0 -> args0 }).orElse(null),
            version = javaType.version(),
        )
    }
}
