@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowedIpRange A valid CIDR block for `IP` filtering. Required for `IP`.
 * @property secretToken The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
 */
public data class WebhookAuthenticationConfiguration(
    public val allowedIpRange: String? = null,
    public val secretToken: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.WebhookAuthenticationConfiguration):
            WebhookAuthenticationConfiguration = WebhookAuthenticationConfiguration(
            allowedIpRange = javaType.allowedIpRange().map({ args0 -> args0 }).orElse(null),
            secretToken = javaType.secretToken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
