@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin

import com.pulumi.aws.codestarconnections.CodestarconnectionsFunctions.getConnectionPlain
import com.pulumi.aws.codestarconnections.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.aws.codestarconnections.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.aws.codestarconnections.kotlin.outputs.GetConnectionResult
import com.pulumi.aws.codestarconnections.kotlin.outputs.GetConnectionResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object CodestarconnectionsFunctions {
    /**
     * Provides details about CodeStar Connection.
     * ## Example Usage
     * ### By ARN
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codestarconnections.CodestarconnectionsFunctions;
     * import com.pulumi.aws.codestarconnections.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodestarconnectionsFunctions.getConnection(GetConnectionArgs.builder()
     *             .arn(aws_codestarconnections_connection.example().arn())
     *             .build());
     *     }
     * }
     * ```
     * ### By Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codestarconnections.CodestarconnectionsFunctions;
     * import com.pulumi.aws.codestarconnections.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodestarconnectionsFunctions.getConnection(GetConnectionArgs.builder()
     *             .name(aws_codestarconnections_connection.example().name())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConnection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        toKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param arn CodeStar Connection ARN.
     * @param name CodeStar Connection name.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     * @param tags Map of key-value resource tags to associate with the resource.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return toKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codestarconnections&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit):
        GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }
}
