@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin

import com.pulumi.aws.codestarconnections.kotlin.outputs.HostVpcConfiguration
import com.pulumi.aws.codestarconnections.kotlin.outputs.HostVpcConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Host].
 */
@PulumiTagMarker
public class HostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostArgs = HostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostArgsBuilder.() -> Unit) {
        val builder = HostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Host {
        val builtJavaResource = com.pulumi.aws.codestarconnections.Host(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Host(builtJavaResource)
    }
}

/**
 * Provides a CodeStar Host.
 * > **NOTE:** The `aws.codestarconnections.Host` resource is created in the state `PENDING`. Authentication with the host provider must be completed in the AWS Console. For more information visit [Set up a pending host](https://docs.aws.amazon.com/dtconsole/latest/userguide/connections-host-setup.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codestarconnections.Host;
 * import com.pulumi.aws.codestarconnections.HostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Host("example", HostArgs.builder()
 *             .providerEndpoint("https://example.com")
 *             .providerType("GitHubEnterpriseServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeStar Host using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:codestarconnections/host:Host example-host arn:aws:codestar-connections:us-west-1:0123456789:host/79d4d357-a2ee-41e4-b350-2fe39ae59448
 * ```
 *
 */
public class Host internal constructor(
    override val javaResource: com.pulumi.aws.codestarconnections.Host,
) : KotlinCustomResource(javaResource, HostMapper) {
    /**
     * The CodeStar Host ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the host to be created. The name must be unique in the calling AWS account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The endpoint of the infrastructure to be represented by the host after it is created.
     */
    public val providerEndpoint: Output<String>
        get() = javaResource.providerEndpoint().applyValue({ args0 -> args0 })

    /**
     * The name of the external provider where your third-party code repository is configured.
     */
    public val providerType: Output<String>
        get() = javaResource.providerType().applyValue({ args0 -> args0 })

    /**
     * The CodeStar Host status. Possible values are `PENDING`, `AVAILABLE`, `VPC_CONFIG_DELETING`, `VPC_CONFIG_INITIALIZING`, and `VPC_CONFIG_FAILED_INITIALIZATION`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The VPC configuration to be provisioned for the host. A VPC must be configured, and the infrastructure to be represented by the host must already be connected to the VPC.
     */
    public val vpcConfiguration: Output<HostVpcConfiguration>?
        get() = javaResource.vpcConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object HostMapper : ResourceMapper<Host> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codestarconnections.Host::class == javaResource::class

    override fun map(javaResource: Resource): Host = Host(
        javaResource as
            com.pulumi.aws.codestarconnections.Host,
    )
}

/**
 * @see [Host].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Host].
 */
public suspend fun host(name: String, block: suspend HostResourceBuilder.() -> Unit): Host {
    val builder = HostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Host].
 * @param name The _unique_ name of the resulting resource.
 */
public fun host(name: String): Host {
    val builder = HostResourceBuilder()
    builder.name(name)
    return builder.build()
}
