@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin

import com.pulumi.aws.codestarconnections.HostArgs.builder
import com.pulumi.aws.codestarconnections.kotlin.inputs.HostVpcConfigurationArgs
import com.pulumi.aws.codestarconnections.kotlin.inputs.HostVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CodeStar Host.
 * > **NOTE:** The `aws.codestarconnections.Host` resource is created in the state `PENDING`. Authentication with the host provider must be completed in the AWS Console. For more information visit [Set up a pending host](https://docs.aws.amazon.com/dtconsole/latest/userguide/connections-host-setup.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codestarconnections.Host;
 * import com.pulumi.aws.codestarconnections.HostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Host("example", HostArgs.builder()
 *             .providerEndpoint("https://example.com")
 *             .providerType("GitHubEnterpriseServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeStar Host using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:codestarconnections/host:Host example-host arn:aws:codestar-connections:us-west-1:0123456789:host/79d4d357-a2ee-41e4-b350-2fe39ae59448
 * ```
 * @property name The name of the host to be created. The name must be unique in the calling AWS account.
 * @property providerEndpoint The endpoint of the infrastructure to be represented by the host after it is created.
 * @property providerType The name of the external provider where your third-party code repository is configured.
 * @property vpcConfiguration The VPC configuration to be provisioned for the host. A VPC must be configured, and the infrastructure to be represented by the host must already be connected to the VPC.
 */
public data class HostArgs(
    public val name: Output<String>? = null,
    public val providerEndpoint: Output<String>? = null,
    public val providerType: Output<String>? = null,
    public val vpcConfiguration: Output<HostVpcConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codestarconnections.HostArgs> {
    override fun toJava(): com.pulumi.aws.codestarconnections.HostArgs =
        com.pulumi.aws.codestarconnections.HostArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .providerEndpoint(providerEndpoint?.applyValue({ args0 -> args0 }))
            .providerType(providerType?.applyValue({ args0 -> args0 }))
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [HostArgs].
 */
@PulumiTagMarker
public class HostArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var providerEndpoint: Output<String>? = null

    private var providerType: Output<String>? = null

    private var vpcConfiguration: Output<HostVpcConfigurationArgs>? = null

    /**
     * @param value The name of the host to be created. The name must be unique in the calling AWS account.
     */
    @JvmName("iswgxpjwuhmmtpac")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The endpoint of the infrastructure to be represented by the host after it is created.
     */
    @JvmName("fjpoeqdtpimcfaop")
    public suspend fun providerEndpoint(`value`: Output<String>) {
        this.providerEndpoint = value
    }

    /**
     * @param value The name of the external provider where your third-party code repository is configured.
     */
    @JvmName("lflhrrbhmqmbernj")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value The VPC configuration to be provisioned for the host. A VPC must be configured, and the infrastructure to be represented by the host must already be connected to the VPC.
     */
    @JvmName("brvyjycriouqwuab")
    public suspend fun vpcConfiguration(`value`: Output<HostVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value The name of the host to be created. The name must be unique in the calling AWS account.
     */
    @JvmName("bvnqogvctmqmbmej")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The endpoint of the infrastructure to be represented by the host after it is created.
     */
    @JvmName("msprmvghenwwhiyc")
    public suspend fun providerEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerEndpoint = mapped
    }

    /**
     * @param value The name of the external provider where your third-party code repository is configured.
     */
    @JvmName("wgcjbgakmvedddqb")
    public suspend fun providerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value The VPC configuration to be provisioned for the host. A VPC must be configured, and the infrastructure to be represented by the host must already be connected to the VPC.
     */
    @JvmName("vygicbwynuhdiyql")
    public suspend fun vpcConfiguration(`value`: HostVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument The VPC configuration to be provisioned for the host. A VPC must be configured, and the infrastructure to be represented by the host must already be connected to the VPC.
     */
    @JvmName("ywglkcmxpslclfpa")
    public suspend
    fun vpcConfiguration(argument: suspend HostVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = HostVpcConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): HostArgs = HostArgs(
        name = name,
        providerEndpoint = providerEndpoint,
        providerType = providerType,
        vpcConfiguration = vpcConfiguration,
    )
}
