@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin.inputs

import com.pulumi.aws.codestarconnections.inputs.GetConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnection.
 * @property arn CodeStar Connection ARN.
 * @property name CodeStar Connection name.
 * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
 * @property tags Map of key-value resource tags to associate with the resource.
 */
public data class GetConnectionPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codestarconnections.inputs.GetConnectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.codestarconnections.inputs.GetConnectionPlainArgs =
        com.pulumi.aws.codestarconnections.inputs.GetConnectionPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value CodeStar Connection ARN.
     */
    @JvmName("weylhaehvsuysvbu")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value CodeStar Connection name.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     */
    @JvmName("fhrdvmkjvbxapgbk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of key-value resource tags to associate with the resource.
     */
    @JvmName("cuqbycfkfeafmkxb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value resource tags to associate with the resource.
     */
    @JvmName("hnalhxccjcrwmlcv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetConnectionPlainArgs = GetConnectionPlainArgs(
        arn = arn,
        name = name,
        tags = tags,
    )
}
