@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin.inputs

import com.pulumi.aws.codestarconnections.inputs.HostVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
 * @property subnetIds The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
 * @property tlsCertificate The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
 * @property vpcId The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
 */
public data class HostVpcConfigurationArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
    public val tlsCertificate: Output<String>? = null,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codestarconnections.inputs.HostVpcConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.codestarconnections.inputs.HostVpcConfigurationArgs =
        com.pulumi.aws.codestarconnections.inputs.HostVpcConfigurationArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tlsCertificate(tlsCertificate?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostVpcConfigurationArgs].
 */
@PulumiTagMarker
public class HostVpcConfigurationArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tlsCertificate: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("mskbuqgwihqytnck")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("sooyijhajbwofrvg")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("jkxcpjxoufadksnx")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("naejnurkolecrcqr")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("dytoypeeaavkwmpr")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("pcqoapxgxawmxmst")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
     */
    @JvmName("hbctwbqfaooaberf")
    public suspend fun tlsCertificate(`value`: Output<String>) {
        this.tlsCertificate = value
    }

    /**
     * @param value The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("fdybkckbhlxdpktw")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("xqwxiefjfammpqrx")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("hsengrnocfbdkjvo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("cxvmqlgjevktuoop")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("jeysifrkqrnovffk")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
     */
    @JvmName("nmdmvptwxkjwnynk")
    public suspend fun tlsCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsCertificate = mapped
    }

    /**
     * @param value The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
     */
    @JvmName("iutkaecafrysldyb")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): HostVpcConfigurationArgs = HostVpcConfigurationArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        tlsCertificate = tlsCertificate,
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
