@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarnotifications.kotlin

import com.pulumi.aws.codestarnotifications.kotlin.outputs.NotificationRuleTarget
import com.pulumi.aws.codestarnotifications.kotlin.outputs.NotificationRuleTarget.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NotificationRule].
 */
@PulumiTagMarker
public class NotificationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationRuleArgs = NotificationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationRuleArgsBuilder.() -> Unit) {
        val builder = NotificationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NotificationRule {
        val builtJavaResource =
            com.pulumi.aws.codestarnotifications.NotificationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotificationRule(builtJavaResource)
    }
}

/**
 * Provides a CodeStar Notifications Rule.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.codestarnotifications.NotificationRule;
 * import com.pulumi.aws.codestarnotifications.NotificationRuleArgs;
 * import com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var code = new Repository("code", RepositoryArgs.builder()
 *             .repositoryName("example-code-repo")
 *             .build());
 *         var notif = new Topic("notif");
 *         final var notifAccess = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sns:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codestar-notifications.amazonaws.com")
 *                     .build())
 *                 .resources(notif.arn())
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(notif.arn())
 *             .policy(notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(notifAccess -> notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var commits = new NotificationRule("commits", NotificationRuleArgs.builder()
 *             .detailType("BASIC")
 *             .eventTypeIds("codecommit-repository-comments-on-commits")
 *             .resource(code.arn())
 *             .targets(NotificationRuleTargetArgs.builder()
 *                 .address(notif.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeStar notification rule using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:codestarnotifications/notificationRule:NotificationRule foo arn:aws:codestar-notifications:us-west-1:0123456789:notificationrule/2cdc68a3-8f7c-4893-b6a5-45b362bd4f2b
 * ```
 *
 */
public class NotificationRule internal constructor(
    override val javaResource: com.pulumi.aws.codestarnotifications.NotificationRule,
) : KotlinCustomResource(javaResource, NotificationRuleMapper) {
    /**
     * The codestar notification rule ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
     */
    public val detailType: Output<String>
        get() = javaResource.detailType().applyValue({ args0 -> args0 })

    /**
     * A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    public val eventTypeIds: Output<List<String>>
        get() = javaResource.eventTypeIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of notification rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the resource to associate with the notification rule.
     */
    public val resource: Output<String>
        get() = javaResource.resource().applyValue({ args0 -> args0 })

    /**
     * The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    public val targets: Output<List<NotificationRuleTarget>>?
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object NotificationRuleMapper : ResourceMapper<NotificationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codestarnotifications.NotificationRule::class == javaResource::class

    override fun map(javaResource: Resource): NotificationRule = NotificationRule(
        javaResource as
            com.pulumi.aws.codestarnotifications.NotificationRule,
    )
}

/**
 * @see [NotificationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationRule].
 */
public suspend fun notificationRule(
    name: String,
    block: suspend NotificationRuleResourceBuilder.() -> Unit,
): NotificationRule {
    val builder = NotificationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationRule(name: String): NotificationRule {
    val builder = NotificationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
