@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarnotifications.kotlin

import com.pulumi.aws.codestarnotifications.NotificationRuleArgs.builder
import com.pulumi.aws.codestarnotifications.kotlin.inputs.NotificationRuleTargetArgs
import com.pulumi.aws.codestarnotifications.kotlin.inputs.NotificationRuleTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeStar Notifications Rule.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.codestarnotifications.NotificationRule;
 * import com.pulumi.aws.codestarnotifications.NotificationRuleArgs;
 * import com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var code = new Repository("code", RepositoryArgs.builder()
 *             .repositoryName("example-code-repo")
 *             .build());
 *         var notif = new Topic("notif");
 *         final var notifAccess = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sns:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codestar-notifications.amazonaws.com")
 *                     .build())
 *                 .resources(notif.arn())
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(notif.arn())
 *             .policy(notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(notifAccess -> notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var commits = new NotificationRule("commits", NotificationRuleArgs.builder()
 *             .detailType("BASIC")
 *             .eventTypeIds("codecommit-repository-comments-on-commits")
 *             .resource(code.arn())
 *             .targets(NotificationRuleTargetArgs.builder()
 *                 .address(notif.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeStar notification rule using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:codestarnotifications/notificationRule:NotificationRule foo arn:aws:codestar-notifications:us-west-1:0123456789:notificationrule/2cdc68a3-8f7c-4893-b6a5-45b362bd4f2b
 * ```
 * @property detailType The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
 * @property eventTypeIds A list of event types associated with this notification rule.
 * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
 * @property name The name of notification rule.
 * @property resource The ARN of the resource to associate with the notification rule.
 * @property status The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targets Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
 */
public data class NotificationRuleArgs(
    public val detailType: Output<String>? = null,
    public val eventTypeIds: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val resource: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targets: Output<List<NotificationRuleTargetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codestarnotifications.NotificationRuleArgs> {
    override fun toJava(): com.pulumi.aws.codestarnotifications.NotificationRuleArgs =
        com.pulumi.aws.codestarnotifications.NotificationRuleArgs.builder()
            .detailType(detailType?.applyValue({ args0 -> args0 }))
            .eventTypeIds(eventTypeIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resource(resource?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NotificationRuleArgs].
 */
@PulumiTagMarker
public class NotificationRuleArgsBuilder internal constructor() {
    private var detailType: Output<String>? = null

    private var eventTypeIds: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var resource: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targets: Output<List<NotificationRuleTargetArgs>>? = null

    /**
     * @param value The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
     */
    @JvmName("fmsjviylpwbcnqbq")
    public suspend fun detailType(`value`: Output<String>) {
        this.detailType = value
    }

    /**
     * @param value A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("pmpjnglkfigmcion")
    public suspend fun eventTypeIds(`value`: Output<List<String>>) {
        this.eventTypeIds = value
    }

    @JvmName("ughboiaudcvpvrjc")
    public suspend fun eventTypeIds(vararg values: Output<String>) {
        this.eventTypeIds = Output.all(values.asList())
    }

    /**
     * @param values A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("xvrgwaverrpktyae")
    public suspend fun eventTypeIds(values: List<Output<String>>) {
        this.eventTypeIds = Output.all(values)
    }

    /**
     * @param value The name of notification rule.
     */
    @JvmName("clerdeypnwwuhbbc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the resource to associate with the notification rule.
     */
    @JvmName("gmvbqfsytybqxxmc")
    public suspend fun resource(`value`: Output<String>) {
        this.resource = value
    }

    /**
     * @param value The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    @JvmName("hgmpfprumhcgqqmf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rsavfgqsgwvqovog")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("eauvhgoandbtttsl")
    public suspend fun targets(`value`: Output<List<NotificationRuleTargetArgs>>) {
        this.targets = value
    }

    @JvmName("kxmnixllncrujulk")
    public suspend fun targets(vararg values: Output<NotificationRuleTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("mmjuuiuxsalkobam")
    public suspend fun targets(values: List<Output<NotificationRuleTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
     */
    @JvmName("vqagtvuaxkaiiylv")
    public suspend fun detailType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailType = mapped
    }

    /**
     * @param value A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("ysgtpwmtersspuho")
    public suspend fun eventTypeIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTypeIds = mapped
    }

    /**
     * @param values A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("udvookgvxiybfwqa")
    public suspend fun eventTypeIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventTypeIds = mapped
    }

    /**
     * @param value The name of notification rule.
     */
    @JvmName("lisqkyysepbaksky")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the resource to associate with the notification rule.
     */
    @JvmName("xcaqiyfuiyywebgg")
    public suspend fun resource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param value The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    @JvmName("qmngmyuvbyptktaa")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uqkhapucovhedton")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ecxodjcmsfiikniw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("bggrkqnxktbipryt")
    public suspend fun targets(`value`: List<NotificationRuleTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("ntdsfpivwoawxrxi")
    public suspend fun targets(argument: List<suspend NotificationRuleTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NotificationRuleTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("pxhlwncxccatsjni")
    public suspend fun targets(
        vararg
        argument: suspend NotificationRuleTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NotificationRuleTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("vcemxwokykuhbgwl")
    public suspend fun targets(argument: suspend NotificationRuleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NotificationRuleTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("fiqkqaowugsocdfa")
    public suspend fun targets(vararg values: NotificationRuleTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): NotificationRuleArgs = NotificationRuleArgs(
        detailType = detailType,
        eventTypeIds = eventTypeIds,
        name = name,
        resource = resource,
        status = status,
        tags = tags,
        targets = targets,
    )
}
