@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.CognitoFunctions.getIdentityPoolPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolClientPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolClientsPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolSigningCertificatePlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolsPlain
import com.pulumi.aws.cognito.kotlin.inputs.GetIdentityPoolPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetIdentityPoolPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientsPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientsPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolSigningCertificatePlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolSigningCertificatePlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolsPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolsPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.outputs.GetIdentityPoolResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientsResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolSigningCertificateResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.cognito.kotlin.outputs.GetIdentityPoolResult.Companion.toKotlin as getIdentityPoolResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientResult.Companion.toKotlin as getUserPoolClientResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientsResult.Companion.toKotlin as getUserPoolClientsResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolSigningCertificateResult.Companion.toKotlin as getUserPoolSigningCertificateResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolsResult.Companion.toKotlin as getUserPoolsResultToKotlin

public object CognitoFunctions {
    /**
     * Data source for managing an AWS Cognito Identity Pool.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetIdentityPoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CognitoFunctions.getIdentityPool(GetIdentityPoolArgs.builder()
     *             .identityPoolName("test pool")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getIdentityPool.
     * @return A collection of values returned by getIdentityPool.
     */
    public suspend fun getIdentityPool(argument: GetIdentityPoolPlainArgs): GetIdentityPoolResult =
        getIdentityPoolResultToKotlin(getIdentityPoolPlain(argument.toJava()).await())

    /**
     * @see [getIdentityPool].
     * @param identityPoolName The Cognito Identity Pool name.
     * @param tags A map of tags to assigned to the Identity Pool.
     * @return A collection of values returned by getIdentityPool.
     */
    public suspend fun getIdentityPool(identityPoolName: String, tags: Map<String, String>? = null):
        GetIdentityPoolResult {
        val argument = GetIdentityPoolPlainArgs(
            identityPoolName = identityPoolName,
            tags = tags,
        )
        return getIdentityPoolResultToKotlin(getIdentityPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getIdentityPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetIdentityPoolPlainArgs].
     * @return A collection of values returned by getIdentityPool.
     */
    public suspend fun getIdentityPool(argument: suspend GetIdentityPoolPlainArgsBuilder.() -> Unit):
        GetIdentityPoolResult {
        val builder = GetIdentityPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIdentityPoolResultToKotlin(getIdentityPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a Cognito User Pool Client resource.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolClientArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var client = CognitoFunctions.getUserPoolClient(GetUserPoolClientArgs.builder()
     *             .clientId("38fjsnc484p94kpqsnet7mpld0")
     *             .userPoolId("us-west-2_aaaaaaaaa")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getUserPoolClient.
     * @return A collection of values returned by getUserPoolClient.
     */
    public suspend fun getUserPoolClient(argument: GetUserPoolClientPlainArgs):
        GetUserPoolClientResult =
        getUserPoolClientResultToKotlin(getUserPoolClientPlain(argument.toJava()).await())

    /**
     * @see [getUserPoolClient].
     * @param clientId Client Id of the user pool.
     * @param userPoolId User pool the client belongs to.
     * @return A collection of values returned by getUserPoolClient.
     */
    public suspend fun getUserPoolClient(clientId: String, userPoolId: String):
        GetUserPoolClientResult {
        val argument = GetUserPoolClientPlainArgs(
            clientId = clientId,
            userPoolId = userPoolId,
        )
        return getUserPoolClientResultToKotlin(getUserPoolClientPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPoolClient].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolClientPlainArgs].
     * @return A collection of values returned by getUserPoolClient.
     */
    public suspend
    fun getUserPoolClient(argument: suspend GetUserPoolClientPlainArgsBuilder.() -> Unit):
        GetUserPoolClientResult {
        val builder = GetUserPoolClientPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolClientResultToKotlin(getUserPoolClientPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of Cognito user pools clients for a Cognito IdP user pool.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolClientsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = CognitoFunctions.getUserPoolClients(GetUserPoolClientsArgs.builder()
     *             .userPoolId(aws_cognito_user_pool.main().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getUserPoolClients.
     * @return A collection of values returned by getUserPoolClients.
     */
    public suspend fun getUserPoolClients(argument: GetUserPoolClientsPlainArgs):
        GetUserPoolClientsResult =
        getUserPoolClientsResultToKotlin(getUserPoolClientsPlain(argument.toJava()).await())

    /**
     * @see [getUserPoolClients].
     * @param userPoolId Cognito user pool ID.
     * @return A collection of values returned by getUserPoolClients.
     */
    public suspend fun getUserPoolClients(userPoolId: String): GetUserPoolClientsResult {
        val argument = GetUserPoolClientsPlainArgs(
            userPoolId = userPoolId,
        )
        return getUserPoolClientsResultToKotlin(getUserPoolClientsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPoolClients].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolClientsPlainArgs].
     * @return A collection of values returned by getUserPoolClients.
     */
    public suspend
    fun getUserPoolClients(argument: suspend GetUserPoolClientsPlainArgsBuilder.() -> Unit):
        GetUserPoolClientsResult {
        val builder = GetUserPoolClientsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolClientsResultToKotlin(getUserPoolClientsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the signing certificate for a Cognito IdP user pool.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolSigningCertificateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sc = CognitoFunctions.getUserPoolSigningCertificate(GetUserPoolSigningCertificateArgs.builder()
     *             .userPoolId(aws_cognito_user_pool.my_pool().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getUserPoolSigningCertificate.
     * @return A collection of values returned by getUserPoolSigningCertificate.
     */
    public suspend
    fun getUserPoolSigningCertificate(argument: GetUserPoolSigningCertificatePlainArgs):
        GetUserPoolSigningCertificateResult =
        getUserPoolSigningCertificateResultToKotlin(getUserPoolSigningCertificatePlain(argument.toJava()).await())

    /**
     * @see [getUserPoolSigningCertificate].
     * @param userPoolId Cognito user pool ID.
     * @return A collection of values returned by getUserPoolSigningCertificate.
     */
    public suspend fun getUserPoolSigningCertificate(userPoolId: String):
        GetUserPoolSigningCertificateResult {
        val argument = GetUserPoolSigningCertificatePlainArgs(
            userPoolId = userPoolId,
        )
        return getUserPoolSigningCertificateResultToKotlin(getUserPoolSigningCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPoolSigningCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolSigningCertificatePlainArgs].
     * @return A collection of values returned by getUserPoolSigningCertificate.
     */
    public suspend
    fun getUserPoolSigningCertificate(argument: suspend GetUserPoolSigningCertificatePlainArgsBuilder.() -> Unit):
        GetUserPoolSigningCertificateResult {
        val builder = GetUserPoolSigningCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolSigningCertificateResultToKotlin(getUserPoolSigningCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of cognito user pools.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetRestApiArgs;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolsArgs;
     * import com.pulumi.aws.apigateway.Authorizer;
     * import com.pulumi.aws.apigateway.AuthorizerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selectedRestApi = ApigatewayFunctions.getRestApi(GetRestApiArgs.builder()
     *             .name(var_.api_gateway_name())
     *             .build());
     *         final var selectedUserPools = CognitoFunctions.getUserPools(GetUserPoolsArgs.builder()
     *             .name(var_.cognito_user_pool_name())
     *             .build());
     *         var cognito = new Authorizer("cognito", AuthorizerArgs.builder()
     *             .type("COGNITO_USER_POOLS")
     *             .restApi(selectedRestApi.applyValue(getRestApiResult -> getRestApiResult.id()))
     *             .providerArns(selectedUserPools.applyValue(getUserPoolsResult -> getUserPoolsResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getUserPools.
     * @return A collection of values returned by getUserPools.
     */
    public suspend fun getUserPools(argument: GetUserPoolsPlainArgs): GetUserPoolsResult =
        getUserPoolsResultToKotlin(getUserPoolsPlain(argument.toJava()).await())

    /**
     * @see [getUserPools].
     * @param name Name of the cognito user pools. Name is not a unique attribute for cognito user pool, so multiple pools might be returned with given name. If the pool name is expected to be unique, you can reference the pool id via ```tolist(data.aws_cognito_user_pools.selected.ids)[0]```
     * @return A collection of values returned by getUserPools.
     */
    public suspend fun getUserPools(name: String): GetUserPoolsResult {
        val argument = GetUserPoolsPlainArgs(
            name = name,
        )
        return getUserPoolsResultToKotlin(getUserPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolsPlainArgs].
     * @return A collection of values returned by getUserPools.
     */
    public suspend fun getUserPools(argument: suspend GetUserPoolsPlainArgsBuilder.() -> Unit):
        GetUserPoolsResult {
        val builder = GetUserPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolsResultToKotlin(getUserPoolsPlain(builtArgument.toJava()).await())
    }
}
