@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.IdentityPoolArgs.builder
import com.pulumi.aws.cognito.kotlin.inputs.IdentityPoolCognitoIdentityProviderArgs
import com.pulumi.aws.cognito.kotlin.inputs.IdentityPoolCognitoIdentityProviderArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Cognito Identity Pool.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SamlProvider;
 * import com.pulumi.aws.iam.SamlProviderArgs;
 * import com.pulumi.aws.cognito.IdentityPool;
 * import com.pulumi.aws.cognito.IdentityPoolArgs;
 * import com.pulumi.aws.cognito.inputs.IdentityPoolCognitoIdentityProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SamlProvider("default", SamlProviderArgs.builder()
 *             .samlMetadataDocument(Files.readString(Paths.get("saml-metadata.xml")))
 *             .build());
 *         var main = new IdentityPool("main", IdentityPoolArgs.builder()
 *             .identityPoolName("identity pool")
 *             .allowUnauthenticatedIdentities(false)
 *             .allowClassicFlow(false)
 *             .cognitoIdentityProviders(
 *                 IdentityPoolCognitoIdentityProviderArgs.builder()
 *                     .clientId("6lhlkkfbfb4q5kpp90urffae")
 *                     .providerName("cognito-idp.us-east-1.amazonaws.com/us-east-1_Tv0493apJ")
 *                     .serverSideTokenCheck(false)
 *                     .build(),
 *                 IdentityPoolCognitoIdentityProviderArgs.builder()
 *                     .clientId("7kodkvfqfb4qfkp39eurffae")
 *                     .providerName("cognito-idp.us-east-1.amazonaws.com/eu-west-1_Zr231apJu")
 *                     .serverSideTokenCheck(false)
 *                     .build())
 *             .supportedLoginProviders(Map.ofEntries(
 *                 Map.entry("graph.facebook.com", "7346241598935552"),
 *                 Map.entry("accounts.google.com", "123456789012.apps.googleusercontent.com")
 *             ))
 *             .samlProviderArns(default_.arn())
 *             .openidConnectProviderArns("arn:aws:iam::123456789012:oidc-provider/id.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito Identity Pool using its ID. For example:
 * ```sh
 *  $ pulumi import aws:cognito/identityPool:IdentityPool mypool us-west-2:1a234567-8901-234b-5cde-f6789g01h2i3
 * ```
 * @property allowClassicFlow Enables or disables the classic / basic authentication flow. Default is `false`.
 * @property allowUnauthenticatedIdentities Whether the identity pool supports unauthenticated logins or not.
 * @property cognitoIdentityProviders An array of Amazon Cognito Identity user pools and their client IDs.
 * @property developerProviderName The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your
 * backend and the Cognito service to communicate about the developer provider.
 * @property identityPoolName The Cognito Identity Pool name.
 * @property openidConnectProviderArns Set of OpendID Connect provider ARNs.
 * @property samlProviderArns An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
 * @property supportedLoginProviders Key-Value pairs mapping provider names to provider app IDs.
 * @property tags A map of tags to assign to the Identity Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class IdentityPoolArgs(
    public val allowClassicFlow: Output<Boolean>? = null,
    public val allowUnauthenticatedIdentities: Output<Boolean>? = null,
    public val cognitoIdentityProviders: Output<List<IdentityPoolCognitoIdentityProviderArgs>>? =
        null,
    public val developerProviderName: Output<String>? = null,
    public val identityPoolName: Output<String>? = null,
    public val openidConnectProviderArns: Output<List<String>>? = null,
    public val samlProviderArns: Output<List<String>>? = null,
    public val supportedLoginProviders: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.IdentityPoolArgs> {
    override fun toJava(): com.pulumi.aws.cognito.IdentityPoolArgs =
        com.pulumi.aws.cognito.IdentityPoolArgs.builder()
            .allowClassicFlow(allowClassicFlow?.applyValue({ args0 -> args0 }))
            .allowUnauthenticatedIdentities(allowUnauthenticatedIdentities?.applyValue({ args0 -> args0 }))
            .cognitoIdentityProviders(
                cognitoIdentityProviders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .developerProviderName(developerProviderName?.applyValue({ args0 -> args0 }))
            .identityPoolName(identityPoolName?.applyValue({ args0 -> args0 }))
            .openidConnectProviderArns(
                openidConnectProviderArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .samlProviderArns(samlProviderArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .supportedLoginProviders(
                supportedLoginProviders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IdentityPoolArgs].
 */
@PulumiTagMarker
public class IdentityPoolArgsBuilder internal constructor() {
    private var allowClassicFlow: Output<Boolean>? = null

    private var allowUnauthenticatedIdentities: Output<Boolean>? = null

    private var cognitoIdentityProviders: Output<List<IdentityPoolCognitoIdentityProviderArgs>>? =
        null

    private var developerProviderName: Output<String>? = null

    private var identityPoolName: Output<String>? = null

    private var openidConnectProviderArns: Output<List<String>>? = null

    private var samlProviderArns: Output<List<String>>? = null

    private var supportedLoginProviders: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Enables or disables the classic / basic authentication flow. Default is `false`.
     */
    @JvmName("vcnbvxiprtmmptkn")
    public suspend fun allowClassicFlow(`value`: Output<Boolean>) {
        this.allowClassicFlow = value
    }

    /**
     * @param value Whether the identity pool supports unauthenticated logins or not.
     */
    @JvmName("qtdxlnatjhvkoeld")
    public suspend fun allowUnauthenticatedIdentities(`value`: Output<Boolean>) {
        this.allowUnauthenticatedIdentities = value
    }

    /**
     * @param value An array of Amazon Cognito Identity user pools and their client IDs.
     */
    @JvmName("kryiguagabuccmya")
    public suspend
    fun cognitoIdentityProviders(`value`: Output<List<IdentityPoolCognitoIdentityProviderArgs>>) {
        this.cognitoIdentityProviders = value
    }

    @JvmName("ofgokcrmmtsnjbva")
    public suspend fun cognitoIdentityProviders(
        vararg
        values: Output<IdentityPoolCognitoIdentityProviderArgs>,
    ) {
        this.cognitoIdentityProviders = Output.all(values.asList())
    }

    /**
     * @param values An array of Amazon Cognito Identity user pools and their client IDs.
     */
    @JvmName("qvauuwunlbdnssru")
    public suspend
    fun cognitoIdentityProviders(values: List<Output<IdentityPoolCognitoIdentityProviderArgs>>) {
        this.cognitoIdentityProviders = Output.all(values)
    }

    /**
     * @param value The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your
     * backend and the Cognito service to communicate about the developer provider.
     */
    @JvmName("mdogbwywwfjkljds")
    public suspend fun developerProviderName(`value`: Output<String>) {
        this.developerProviderName = value
    }

    /**
     * @param value The Cognito Identity Pool name.
     */
    @JvmName("mawyjxvrfltagibd")
    public suspend fun identityPoolName(`value`: Output<String>) {
        this.identityPoolName = value
    }

    /**
     * @param value Set of OpendID Connect provider ARNs.
     */
    @JvmName("jljkptvxkyghpwlu")
    public suspend fun openidConnectProviderArns(`value`: Output<List<String>>) {
        this.openidConnectProviderArns = value
    }

    @JvmName("pjnhpucvhpmjywnj")
    public suspend fun openidConnectProviderArns(vararg values: Output<String>) {
        this.openidConnectProviderArns = Output.all(values.asList())
    }

    /**
     * @param values Set of OpendID Connect provider ARNs.
     */
    @JvmName("tlyynngqojhcqfhr")
    public suspend fun openidConnectProviderArns(values: List<Output<String>>) {
        this.openidConnectProviderArns = Output.all(values)
    }

    /**
     * @param value An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
     */
    @JvmName("nrtfrtogwkmytwkq")
    public suspend fun samlProviderArns(`value`: Output<List<String>>) {
        this.samlProviderArns = value
    }

    @JvmName("xornobnuehovmemx")
    public suspend fun samlProviderArns(vararg values: Output<String>) {
        this.samlProviderArns = Output.all(values.asList())
    }

    /**
     * @param values An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
     */
    @JvmName("nuynnpkqohxmasqk")
    public suspend fun samlProviderArns(values: List<Output<String>>) {
        this.samlProviderArns = Output.all(values)
    }

    /**
     * @param value Key-Value pairs mapping provider names to provider app IDs.
     */
    @JvmName("eydmmqyvrpvayloy")
    public suspend fun supportedLoginProviders(`value`: Output<Map<String, String>>) {
        this.supportedLoginProviders = value
    }

    /**
     * @param value A map of tags to assign to the Identity Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mbcokyxuynytvaeq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enables or disables the classic / basic authentication flow. Default is `false`.
     */
    @JvmName("whelneevpfhcanxt")
    public suspend fun allowClassicFlow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowClassicFlow = mapped
    }

    /**
     * @param value Whether the identity pool supports unauthenticated logins or not.
     */
    @JvmName("pigrgtaaeeabaigj")
    public suspend fun allowUnauthenticatedIdentities(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUnauthenticatedIdentities = mapped
    }

    /**
     * @param value An array of Amazon Cognito Identity user pools and their client IDs.
     */
    @JvmName("fayjxqcwwhhhswil")
    public suspend
    fun cognitoIdentityProviders(`value`: List<IdentityPoolCognitoIdentityProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoIdentityProviders = mapped
    }

    /**
     * @param argument An array of Amazon Cognito Identity user pools and their client IDs.
     */
    @JvmName("axuatbvpmggggcsj")
    public suspend
    fun cognitoIdentityProviders(argument: List<suspend IdentityPoolCognitoIdentityProviderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IdentityPoolCognitoIdentityProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cognitoIdentityProviders = mapped
    }

    /**
     * @param argument An array of Amazon Cognito Identity user pools and their client IDs.
     */
    @JvmName("wgtsiyigesgbvvxg")
    public suspend fun cognitoIdentityProviders(
        vararg
        argument: suspend IdentityPoolCognitoIdentityProviderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IdentityPoolCognitoIdentityProviderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cognitoIdentityProviders = mapped
    }

    /**
     * @param argument An array of Amazon Cognito Identity user pools and their client IDs.
     */
    @JvmName("xmuockqqfhoesspd")
    public suspend
    fun cognitoIdentityProviders(argument: suspend IdentityPoolCognitoIdentityProviderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IdentityPoolCognitoIdentityProviderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cognitoIdentityProviders = mapped
    }

    /**
     * @param values An array of Amazon Cognito Identity user pools and their client IDs.
     */
    @JvmName("lntimxucuwhniypj")
    public suspend fun cognitoIdentityProviders(
        vararg
        values: IdentityPoolCognitoIdentityProviderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cognitoIdentityProviders = mapped
    }

    /**
     * @param value The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your
     * backend and the Cognito service to communicate about the developer provider.
     */
    @JvmName("wnogxtggxffxpabl")
    public suspend fun developerProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerProviderName = mapped
    }

    /**
     * @param value The Cognito Identity Pool name.
     */
    @JvmName("umjhubwvslmhhulo")
    public suspend fun identityPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityPoolName = mapped
    }

    /**
     * @param value Set of OpendID Connect provider ARNs.
     */
    @JvmName("jojxrrhxievxwill")
    public suspend fun openidConnectProviderArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openidConnectProviderArns = mapped
    }

    /**
     * @param values Set of OpendID Connect provider ARNs.
     */
    @JvmName("dpsfumapmustobvk")
    public suspend fun openidConnectProviderArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.openidConnectProviderArns = mapped
    }

    /**
     * @param value An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
     */
    @JvmName("ghlwilbbyhndbswy")
    public suspend fun samlProviderArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlProviderArns = mapped
    }

    /**
     * @param values An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
     */
    @JvmName("gtauqyayskboortv")
    public suspend fun samlProviderArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samlProviderArns = mapped
    }

    /**
     * @param value Key-Value pairs mapping provider names to provider app IDs.
     */
    @JvmName("ntdiapkrgnfrkkhr")
    public suspend fun supportedLoginProviders(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedLoginProviders = mapped
    }

    /**
     * @param values Key-Value pairs mapping provider names to provider app IDs.
     */
    @JvmName("yfxfcxbsunpdmsbm")
    public fun supportedLoginProviders(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedLoginProviders = mapped
    }

    /**
     * @param value A map of tags to assign to the Identity Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pdsncfmmkkjmksrm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Identity Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dkwxqjwaghcxmghc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IdentityPoolArgs = IdentityPoolArgs(
        allowClassicFlow = allowClassicFlow,
        allowUnauthenticatedIdentities = allowUnauthenticatedIdentities,
        cognitoIdentityProviders = cognitoIdentityProviders,
        developerProviderName = developerProviderName,
        identityPoolName = identityPoolName,
        openidConnectProviderArns = openidConnectProviderArns,
        samlProviderArns = samlProviderArns,
        supportedLoginProviders = supportedLoginProviders,
        tags = tags,
    )
}
