@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.ManagedUserPoolClientArgs.builder
import com.pulumi.aws.cognito.kotlin.inputs.ManagedUserPoolClientAnalyticsConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.ManagedUserPoolClientAnalyticsConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.ManagedUserPoolClientTokenValidityUnitsArgs
import com.pulumi.aws.cognito.kotlin.inputs.ManagedUserPoolClientTokenValidityUnitsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Use the `aws.cognito.UserPoolClient` resource to manage a Cognito User Pool Client.
 * **This resource is advanced** and has special caveats to consider before use. Please read this document completely before using the resource.
 * Use the `aws.cognito.ManagedUserPoolClient` resource to manage a Cognito User Pool Client that is automatically created by an AWS service. For instance, when [configuring an OpenSearch Domain to use Cognito authentication](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html), the OpenSearch service creates the User Pool Client during setup and removes it when it is no longer required. As a result, the `aws.cognito.ManagedUserPoolClient` resource does not create or delete this resource, but instead assumes management of it.
 * Use the `aws.cognito.UserPoolClient` resource to manage Cognito User Pool Clients for normal use cases.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.IdentityPool;
 * import com.pulumi.aws.cognito.IdentityPoolArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainCognitoOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.cognito.ManagedUserPoolClient;
 * import com.pulumi.aws.cognito.ManagedUserPoolClientArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var exampleIdentityPool = new IdentityPool("exampleIdentityPool", IdentityPoolArgs.builder()
 *             .identityPoolName("example")
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("")
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(String.format("es.%s", current.applyValue(getPartitionResult -> getPartitionResult.dnsSuffix())))
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .path("/service-role/")
 *             .assumeRolePolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(exampleRole.name())
 *             .policyArn(String.format("arn:%s:iam::aws:policy/AmazonESCognitoAccess", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .cognitoOptions(DomainCognitoOptionsArgs.builder()
 *                 .enabled(true)
 *                 .userPoolId(exampleUserPool.id())
 *                 .identityPoolId(exampleIdentityPool.id())
 *                 .roleArn(exampleRole.arn())
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     aws_cognito_user_pool_domain.example(),
 *                     exampleRolePolicyAttachment)
 *                 .build());
 *         var exampleManagedUserPoolClient = new ManagedUserPoolClient("exampleManagedUserPoolClient", ManagedUserPoolClientArgs.builder()
 *             .namePrefix("AmazonOpenSearchService-example")
 *             .userPoolId(exampleUserPool.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleDomain)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User Pool Clients using the `id` of the Cognito User Pool and the `id` of the Cognito User Pool Client. For example:
 * ```sh
 *  $ pulumi import aws:cognito/managedUserPoolClient:ManagedUserPoolClient client us-west-2_abc123/3ho4ek12345678909nh3fmhpko
 * ```
 * @property accessTokenValidity Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
 * @property allowedOauthFlows List of allowed OAuth flows, including code, implicit, and client_credentials.
 * @property allowedOauthFlowsUserPoolClient Whether the client is allowed to use the OAuth protocol when interacting with Cognito user pools.
 * @property allowedOauthScopes List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
 * @property analyticsConfiguration Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
 * @property authSessionValidity Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
 * @property callbackUrls List of allowed callback URLs for the identity providers.
 * @property defaultRedirectUri Default redirect URI and must be included in the list of callback URLs.
 * @property enablePropagateAdditionalUserContextData Enables the propagation of additional user context data.
 * @property enableTokenRevocation Enables or disables token revocation.
 * @property explicitAuthFlows List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
 * @property idTokenValidity Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
 * @property logoutUrls List of allowed logout URLs for the identity providers.
 * @property namePattern Regular expression that matches the name of the desired User Pool Client. It must only match one User Pool Client.
 * @property namePrefix String that matches the beginning of the name of the desired User Pool Client. It must match only one User Pool Client.
 * The following arguments are optional:
 * @property preventUserExistenceErrors Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
 * @property readAttributes List of user pool attributes that the application client can read from.
 * @property refreshTokenValidity Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
 * @property supportedIdentityProviders List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
 * @property tokenValidityUnits Configuration block for representing the validity times in units. See details below. Detailed below.
 * @property userPoolId User pool that the client belongs to.
 * @property writeAttributes List of user pool attributes that the application client can write to.
 */
public data class ManagedUserPoolClientArgs(
    public val accessTokenValidity: Output<Int>? = null,
    public val allowedOauthFlows: Output<List<String>>? = null,
    public val allowedOauthFlowsUserPoolClient: Output<Boolean>? = null,
    public val allowedOauthScopes: Output<List<String>>? = null,
    public val analyticsConfiguration: Output<ManagedUserPoolClientAnalyticsConfigurationArgs>? =
        null,
    public val authSessionValidity: Output<Int>? = null,
    public val callbackUrls: Output<List<String>>? = null,
    public val defaultRedirectUri: Output<String>? = null,
    public val enablePropagateAdditionalUserContextData: Output<Boolean>? = null,
    public val enableTokenRevocation: Output<Boolean>? = null,
    public val explicitAuthFlows: Output<List<String>>? = null,
    public val idTokenValidity: Output<Int>? = null,
    public val logoutUrls: Output<List<String>>? = null,
    public val namePattern: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val preventUserExistenceErrors: Output<String>? = null,
    public val readAttributes: Output<List<String>>? = null,
    public val refreshTokenValidity: Output<Int>? = null,
    public val supportedIdentityProviders: Output<List<String>>? = null,
    public val tokenValidityUnits: Output<ManagedUserPoolClientTokenValidityUnitsArgs>? = null,
    public val userPoolId: Output<String>? = null,
    public val writeAttributes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.ManagedUserPoolClientArgs> {
    override fun toJava(): com.pulumi.aws.cognito.ManagedUserPoolClientArgs =
        com.pulumi.aws.cognito.ManagedUserPoolClientArgs.builder()
            .accessTokenValidity(accessTokenValidity?.applyValue({ args0 -> args0 }))
            .allowedOauthFlows(allowedOauthFlows?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOauthFlowsUserPoolClient(allowedOauthFlowsUserPoolClient?.applyValue({ args0 -> args0 }))
            .allowedOauthScopes(allowedOauthScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .analyticsConfiguration(
                analyticsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .authSessionValidity(authSessionValidity?.applyValue({ args0 -> args0 }))
            .callbackUrls(callbackUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defaultRedirectUri(defaultRedirectUri?.applyValue({ args0 -> args0 }))
            .enablePropagateAdditionalUserContextData(
                enablePropagateAdditionalUserContextData?.applyValue({ args0 ->
                    args0
                }),
            )
            .enableTokenRevocation(enableTokenRevocation?.applyValue({ args0 -> args0 }))
            .explicitAuthFlows(explicitAuthFlows?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .idTokenValidity(idTokenValidity?.applyValue({ args0 -> args0 }))
            .logoutUrls(logoutUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .namePattern(namePattern?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .preventUserExistenceErrors(preventUserExistenceErrors?.applyValue({ args0 -> args0 }))
            .readAttributes(readAttributes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .refreshTokenValidity(refreshTokenValidity?.applyValue({ args0 -> args0 }))
            .supportedIdentityProviders(
                supportedIdentityProviders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tokenValidityUnits(
                tokenValidityUnits?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 }))
            .writeAttributes(writeAttributes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ManagedUserPoolClientArgs].
 */
@PulumiTagMarker
public class ManagedUserPoolClientArgsBuilder internal constructor() {
    private var accessTokenValidity: Output<Int>? = null

    private var allowedOauthFlows: Output<List<String>>? = null

    private var allowedOauthFlowsUserPoolClient: Output<Boolean>? = null

    private var allowedOauthScopes: Output<List<String>>? = null

    private var analyticsConfiguration: Output<ManagedUserPoolClientAnalyticsConfigurationArgs>? =
        null

    private var authSessionValidity: Output<Int>? = null

    private var callbackUrls: Output<List<String>>? = null

    private var defaultRedirectUri: Output<String>? = null

    private var enablePropagateAdditionalUserContextData: Output<Boolean>? = null

    private var enableTokenRevocation: Output<Boolean>? = null

    private var explicitAuthFlows: Output<List<String>>? = null

    private var idTokenValidity: Output<Int>? = null

    private var logoutUrls: Output<List<String>>? = null

    private var namePattern: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var preventUserExistenceErrors: Output<String>? = null

    private var readAttributes: Output<List<String>>? = null

    private var refreshTokenValidity: Output<Int>? = null

    private var supportedIdentityProviders: Output<List<String>>? = null

    private var tokenValidityUnits: Output<ManagedUserPoolClientTokenValidityUnitsArgs>? = null

    private var userPoolId: Output<String>? = null

    private var writeAttributes: Output<List<String>>? = null

    /**
     * @param value Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
     */
    @JvmName("qyoiemnfckialins")
    public suspend fun accessTokenValidity(`value`: Output<Int>) {
        this.accessTokenValidity = value
    }

    /**
     * @param value List of allowed OAuth flows, including code, implicit, and client_credentials.
     */
    @JvmName("lcmmmngpsihkvqxs")
    public suspend fun allowedOauthFlows(`value`: Output<List<String>>) {
        this.allowedOauthFlows = value
    }

    @JvmName("elrstwtepptxvbcd")
    public suspend fun allowedOauthFlows(vararg values: Output<String>) {
        this.allowedOauthFlows = Output.all(values.asList())
    }

    /**
     * @param values List of allowed OAuth flows, including code, implicit, and client_credentials.
     */
    @JvmName("yjgxcyfvbwigocfw")
    public suspend fun allowedOauthFlows(values: List<Output<String>>) {
        this.allowedOauthFlows = Output.all(values)
    }

    /**
     * @param value Whether the client is allowed to use the OAuth protocol when interacting with Cognito user pools.
     */
    @JvmName("pfkepwrvarolsgty")
    public suspend fun allowedOauthFlowsUserPoolClient(`value`: Output<Boolean>) {
        this.allowedOauthFlowsUserPoolClient = value
    }

    /**
     * @param value List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
     */
    @JvmName("tqmxrvprewwvbwon")
    public suspend fun allowedOauthScopes(`value`: Output<List<String>>) {
        this.allowedOauthScopes = value
    }

    @JvmName("cdwfmwevrlfemohn")
    public suspend fun allowedOauthScopes(vararg values: Output<String>) {
        this.allowedOauthScopes = Output.all(values.asList())
    }

    /**
     * @param values List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
     */
    @JvmName("ogabdwpcfscudvho")
    public suspend fun allowedOauthScopes(values: List<Output<String>>) {
        this.allowedOauthScopes = Output.all(values)
    }

    /**
     * @param value Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
     */
    @JvmName("ghogsrbvobdvyjwf")
    public suspend
    fun analyticsConfiguration(`value`: Output<ManagedUserPoolClientAnalyticsConfigurationArgs>) {
        this.analyticsConfiguration = value
    }

    /**
     * @param value Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
     */
    @JvmName("knjyaotnmfrlahft")
    public suspend fun authSessionValidity(`value`: Output<Int>) {
        this.authSessionValidity = value
    }

    /**
     * @param value List of allowed callback URLs for the identity providers.
     */
    @JvmName("qqrnutxuubiwrwub")
    public suspend fun callbackUrls(`value`: Output<List<String>>) {
        this.callbackUrls = value
    }

    @JvmName("daxewcgecmvytcdu")
    public suspend fun callbackUrls(vararg values: Output<String>) {
        this.callbackUrls = Output.all(values.asList())
    }

    /**
     * @param values List of allowed callback URLs for the identity providers.
     */
    @JvmName("pnrwkfyqmjprjhse")
    public suspend fun callbackUrls(values: List<Output<String>>) {
        this.callbackUrls = Output.all(values)
    }

    /**
     * @param value Default redirect URI and must be included in the list of callback URLs.
     */
    @JvmName("dnjntimkfilmfyxn")
    public suspend fun defaultRedirectUri(`value`: Output<String>) {
        this.defaultRedirectUri = value
    }

    /**
     * @param value Enables the propagation of additional user context data.
     */
    @JvmName("rqhwgihpsdpebwye")
    public suspend fun enablePropagateAdditionalUserContextData(`value`: Output<Boolean>) {
        this.enablePropagateAdditionalUserContextData = value
    }

    /**
     * @param value Enables or disables token revocation.
     */
    @JvmName("wtkgbfbeirjailnn")
    public suspend fun enableTokenRevocation(`value`: Output<Boolean>) {
        this.enableTokenRevocation = value
    }

    /**
     * @param value List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
     */
    @JvmName("gfbvgefgxkfthfof")
    public suspend fun explicitAuthFlows(`value`: Output<List<String>>) {
        this.explicitAuthFlows = value
    }

    @JvmName("nsuusiawgrqxksok")
    public suspend fun explicitAuthFlows(vararg values: Output<String>) {
        this.explicitAuthFlows = Output.all(values.asList())
    }

    /**
     * @param values List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
     */
    @JvmName("pqyicyerayccswfa")
    public suspend fun explicitAuthFlows(values: List<Output<String>>) {
        this.explicitAuthFlows = Output.all(values)
    }

    /**
     * @param value Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
     */
    @JvmName("prytegtfvmioxcij")
    public suspend fun idTokenValidity(`value`: Output<Int>) {
        this.idTokenValidity = value
    }

    /**
     * @param value List of allowed logout URLs for the identity providers.
     */
    @JvmName("paomfydwircyegvc")
    public suspend fun logoutUrls(`value`: Output<List<String>>) {
        this.logoutUrls = value
    }

    @JvmName("pohtoyuchvgeewsb")
    public suspend fun logoutUrls(vararg values: Output<String>) {
        this.logoutUrls = Output.all(values.asList())
    }

    /**
     * @param values List of allowed logout URLs for the identity providers.
     */
    @JvmName("hypkuqvskwqsqssd")
    public suspend fun logoutUrls(values: List<Output<String>>) {
        this.logoutUrls = Output.all(values)
    }

    /**
     * @param value Regular expression that matches the name of the desired User Pool Client. It must only match one User Pool Client.
     */
    @JvmName("ebosbgdnvxmcpghx")
    public suspend fun namePattern(`value`: Output<String>) {
        this.namePattern = value
    }

    /**
     * @param value String that matches the beginning of the name of the desired User Pool Client. It must match only one User Pool Client.
     * The following arguments are optional:
     */
    @JvmName("ehmptrejbuexjtva")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
     */
    @JvmName("jiryuaympwilnrvf")
    public suspend fun preventUserExistenceErrors(`value`: Output<String>) {
        this.preventUserExistenceErrors = value
    }

    /**
     * @param value List of user pool attributes that the application client can read from.
     */
    @JvmName("lpeewrvsimuuxeyg")
    public suspend fun readAttributes(`value`: Output<List<String>>) {
        this.readAttributes = value
    }

    @JvmName("oqbnoehglstcpkju")
    public suspend fun readAttributes(vararg values: Output<String>) {
        this.readAttributes = Output.all(values.asList())
    }

    /**
     * @param values List of user pool attributes that the application client can read from.
     */
    @JvmName("vlhrvbmckharrgym")
    public suspend fun readAttributes(values: List<Output<String>>) {
        this.readAttributes = Output.all(values)
    }

    /**
     * @param value Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
     */
    @JvmName("iojxqdeifgsskqqw")
    public suspend fun refreshTokenValidity(`value`: Output<Int>) {
        this.refreshTokenValidity = value
    }

    /**
     * @param value List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     */
    @JvmName("awkqlifqptvfpqmn")
    public suspend fun supportedIdentityProviders(`value`: Output<List<String>>) {
        this.supportedIdentityProviders = value
    }

    @JvmName("tdxoanmxrpsacbmx")
    public suspend fun supportedIdentityProviders(vararg values: Output<String>) {
        this.supportedIdentityProviders = Output.all(values.asList())
    }

    /**
     * @param values List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     */
    @JvmName("bsmfxttvpnvrapto")
    public suspend fun supportedIdentityProviders(values: List<Output<String>>) {
        this.supportedIdentityProviders = Output.all(values)
    }

    /**
     * @param value Configuration block for representing the validity times in units. See details below. Detailed below.
     */
    @JvmName("gkvmbuglcqfipmyy")
    public suspend
    fun tokenValidityUnits(`value`: Output<ManagedUserPoolClientTokenValidityUnitsArgs>) {
        this.tokenValidityUnits = value
    }

    /**
     * @param value User pool that the client belongs to.
     */
    @JvmName("nkmsbrfjuwvhakor")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value List of user pool attributes that the application client can write to.
     */
    @JvmName("ekeoniijwvsnyltb")
    public suspend fun writeAttributes(`value`: Output<List<String>>) {
        this.writeAttributes = value
    }

    @JvmName("yhtbthpqwkjprtrh")
    public suspend fun writeAttributes(vararg values: Output<String>) {
        this.writeAttributes = Output.all(values.asList())
    }

    /**
     * @param values List of user pool attributes that the application client can write to.
     */
    @JvmName("qnrxvxqgstgtrcpu")
    public suspend fun writeAttributes(values: List<Output<String>>) {
        this.writeAttributes = Output.all(values)
    }

    /**
     * @param value Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
     */
    @JvmName("lwlnjmkvvfklfenb")
    public suspend fun accessTokenValidity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTokenValidity = mapped
    }

    /**
     * @param value List of allowed OAuth flows, including code, implicit, and client_credentials.
     */
    @JvmName("atxligfnxomaciwb")
    public suspend fun allowedOauthFlows(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOauthFlows = mapped
    }

    /**
     * @param values List of allowed OAuth flows, including code, implicit, and client_credentials.
     */
    @JvmName("qdfchoybrmyyrmsu")
    public suspend fun allowedOauthFlows(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOauthFlows = mapped
    }

    /**
     * @param value Whether the client is allowed to use the OAuth protocol when interacting with Cognito user pools.
     */
    @JvmName("pgjxfgedoqvkrnfd")
    public suspend fun allowedOauthFlowsUserPoolClient(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOauthFlowsUserPoolClient = mapped
    }

    /**
     * @param value List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
     */
    @JvmName("iquoowoqmeqxbyks")
    public suspend fun allowedOauthScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOauthScopes = mapped
    }

    /**
     * @param values List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
     */
    @JvmName("yrxarhvlefsardci")
    public suspend fun allowedOauthScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOauthScopes = mapped
    }

    /**
     * @param value Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
     */
    @JvmName("lqcwphmokpoeluhf")
    public suspend
    fun analyticsConfiguration(`value`: ManagedUserPoolClientAnalyticsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticsConfiguration = mapped
    }

    /**
     * @param argument Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
     */
    @JvmName("fedkhsqlljdvmjpg")
    public suspend
    fun analyticsConfiguration(argument: suspend ManagedUserPoolClientAnalyticsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedUserPoolClientAnalyticsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.analyticsConfiguration = mapped
    }

    /**
     * @param value Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
     */
    @JvmName("huvkaysqqmjaieur")
    public suspend fun authSessionValidity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authSessionValidity = mapped
    }

    /**
     * @param value List of allowed callback URLs for the identity providers.
     */
    @JvmName("wonweldwetnnsmhn")
    public suspend fun callbackUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callbackUrls = mapped
    }

    /**
     * @param values List of allowed callback URLs for the identity providers.
     */
    @JvmName("fepfyyotlgxqtaqf")
    public suspend fun callbackUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callbackUrls = mapped
    }

    /**
     * @param value Default redirect URI and must be included in the list of callback URLs.
     */
    @JvmName("cqlohpophayaatys")
    public suspend fun defaultRedirectUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRedirectUri = mapped
    }

    /**
     * @param value Enables the propagation of additional user context data.
     */
    @JvmName("fkywlaufqdnnrdpm")
    public suspend fun enablePropagateAdditionalUserContextData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePropagateAdditionalUserContextData = mapped
    }

    /**
     * @param value Enables or disables token revocation.
     */
    @JvmName("utakbqfndbwtqijt")
    public suspend fun enableTokenRevocation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTokenRevocation = mapped
    }

    /**
     * @param value List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
     */
    @JvmName("lhtnubshvjdjqcya")
    public suspend fun explicitAuthFlows(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.explicitAuthFlows = mapped
    }

    /**
     * @param values List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
     */
    @JvmName("dyugvjceqikonvou")
    public suspend fun explicitAuthFlows(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.explicitAuthFlows = mapped
    }

    /**
     * @param value Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
     */
    @JvmName("ceuddbstaroaoogr")
    public suspend fun idTokenValidity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idTokenValidity = mapped
    }

    /**
     * @param value List of allowed logout URLs for the identity providers.
     */
    @JvmName("jvbhiapfuphboynw")
    public suspend fun logoutUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logoutUrls = mapped
    }

    /**
     * @param values List of allowed logout URLs for the identity providers.
     */
    @JvmName("khpmtoywtqgtghgc")
    public suspend fun logoutUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logoutUrls = mapped
    }

    /**
     * @param value Regular expression that matches the name of the desired User Pool Client. It must only match one User Pool Client.
     */
    @JvmName("hwixopgkchdterbe")
    public suspend fun namePattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePattern = mapped
    }

    /**
     * @param value String that matches the beginning of the name of the desired User Pool Client. It must match only one User Pool Client.
     * The following arguments are optional:
     */
    @JvmName("ngbldbpvjbblqtck")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
     */
    @JvmName("ixrjtjyvsrqhocsc")
    public suspend fun preventUserExistenceErrors(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preventUserExistenceErrors = mapped
    }

    /**
     * @param value List of user pool attributes that the application client can read from.
     */
    @JvmName("kxkvixvogriddvqt")
    public suspend fun readAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readAttributes = mapped
    }

    /**
     * @param values List of user pool attributes that the application client can read from.
     */
    @JvmName("wxjfnjmndwaylhfp")
    public suspend fun readAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readAttributes = mapped
    }

    /**
     * @param value Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
     */
    @JvmName("ymujntufwxvapfyy")
    public suspend fun refreshTokenValidity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshTokenValidity = mapped
    }

    /**
     * @param value List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     */
    @JvmName("wiinlipkrwjlampc")
    public suspend fun supportedIdentityProviders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedIdentityProviders = mapped
    }

    /**
     * @param values List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     */
    @JvmName("mdiavggbfiqbvndw")
    public suspend fun supportedIdentityProviders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedIdentityProviders = mapped
    }

    /**
     * @param value Configuration block for representing the validity times in units. See details below. Detailed below.
     */
    @JvmName("rsmbnbrqtkkpcgxp")
    public suspend fun tokenValidityUnits(`value`: ManagedUserPoolClientTokenValidityUnitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenValidityUnits = mapped
    }

    /**
     * @param argument Configuration block for representing the validity times in units. See details below. Detailed below.
     */
    @JvmName("qtididbaecfpfhac")
    public suspend
    fun tokenValidityUnits(argument: suspend ManagedUserPoolClientTokenValidityUnitsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedUserPoolClientTokenValidityUnitsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tokenValidityUnits = mapped
    }

    /**
     * @param value User pool that the client belongs to.
     */
    @JvmName("wfhvpjvtglxeblmo")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    /**
     * @param value List of user pool attributes that the application client can write to.
     */
    @JvmName("epscpvaijqiljotx")
    public suspend fun writeAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeAttributes = mapped
    }

    /**
     * @param values List of user pool attributes that the application client can write to.
     */
    @JvmName("gpfleehjisgwprxu")
    public suspend fun writeAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeAttributes = mapped
    }

    internal fun build(): ManagedUserPoolClientArgs = ManagedUserPoolClientArgs(
        accessTokenValidity = accessTokenValidity,
        allowedOauthFlows = allowedOauthFlows,
        allowedOauthFlowsUserPoolClient = allowedOauthFlowsUserPoolClient,
        allowedOauthScopes = allowedOauthScopes,
        analyticsConfiguration = analyticsConfiguration,
        authSessionValidity = authSessionValidity,
        callbackUrls = callbackUrls,
        defaultRedirectUri = defaultRedirectUri,
        enablePropagateAdditionalUserContextData = enablePropagateAdditionalUserContextData,
        enableTokenRevocation = enableTokenRevocation,
        explicitAuthFlows = explicitAuthFlows,
        idTokenValidity = idTokenValidity,
        logoutUrls = logoutUrls,
        namePattern = namePattern,
        namePrefix = namePrefix,
        preventUserExistenceErrors = preventUserExistenceErrors,
        readAttributes = readAttributes,
        refreshTokenValidity = refreshTokenValidity,
        supportedIdentityProviders = supportedIdentityProviders,
        tokenValidityUnits = tokenValidityUnits,
        userPoolId = userPoolId,
        writeAttributes = writeAttributes,
    )
}
