@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.RiskConfigurationArgs.builder
import com.pulumi.aws.cognito.kotlin.inputs.RiskConfigurationAccountTakeoverRiskConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.RiskConfigurationAccountTakeoverRiskConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.RiskConfigurationRiskExceptionConfigurationArgs
import com.pulumi.aws.cognito.kotlin.inputs.RiskConfigurationRiskExceptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Cognito Risk Configuration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.RiskConfiguration;
 * import com.pulumi.aws.cognito.RiskConfigurationArgs;
 * import com.pulumi.aws.cognito.inputs.RiskConfigurationRiskExceptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RiskConfiguration("example", RiskConfigurationArgs.builder()
 *             .userPoolId(aws_cognito_user_pool.example().id())
 *             .riskExceptionConfiguration(RiskConfigurationRiskExceptionConfigurationArgs.builder()
 *                 .blockedIpRangeLists("10.10.10.10/32")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import using the user pool ID and Client ID separated by a `:`:
 * __Using `pulumi import` to import__ Cognito Risk Configurations using the user pool ID or the user pool ID and Client Id separated by a `:`. For example:
 * Import using the user pool ID:
 * ```sh
 *  $ pulumi import aws:cognito/riskConfiguration:RiskConfiguration main example
 * ```
 *  Import using the user pool ID and Client ID separated by a `:`:
 * ```sh
 *  $ pulumi import aws:cognito/riskConfiguration:RiskConfiguration main example:example
 * ```
 * @property accountTakeoverRiskConfiguration The account takeover risk configuration. See details below.
 * @property clientId The app client ID. When the client ID is not provided, the same risk configuration is applied to all the clients in the User Pool.
 * @property compromisedCredentialsRiskConfiguration The compromised credentials risk configuration. See details below.
 * @property riskExceptionConfiguration The configuration to override the risk decision. See details below.
 * @property userPoolId The user pool ID.
 */
public data class RiskConfigurationArgs(
    public val accountTakeoverRiskConfiguration:
    Output<RiskConfigurationAccountTakeoverRiskConfigurationArgs>? = null,
    public val clientId: Output<String>? = null,
    public val compromisedCredentialsRiskConfiguration:
    Output<RiskConfigurationCompromisedCredentialsRiskConfigurationArgs>? = null,
    public val riskExceptionConfiguration: Output<RiskConfigurationRiskExceptionConfigurationArgs>? =
        null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.RiskConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.RiskConfigurationArgs =
        com.pulumi.aws.cognito.RiskConfigurationArgs.builder()
            .accountTakeoverRiskConfiguration(
                accountTakeoverRiskConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .compromisedCredentialsRiskConfiguration(
                compromisedCredentialsRiskConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .riskExceptionConfiguration(
                riskExceptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RiskConfigurationArgs].
 */
@PulumiTagMarker
public class RiskConfigurationArgsBuilder internal constructor() {
    private var accountTakeoverRiskConfiguration:
        Output<RiskConfigurationAccountTakeoverRiskConfigurationArgs>? = null

    private var clientId: Output<String>? = null

    private var compromisedCredentialsRiskConfiguration:
        Output<RiskConfigurationCompromisedCredentialsRiskConfigurationArgs>? = null

    private var riskExceptionConfiguration: Output<RiskConfigurationRiskExceptionConfigurationArgs>? =
        null

    private var userPoolId: Output<String>? = null

    /**
     * @param value The account takeover risk configuration. See details below.
     */
    @JvmName("okucewnsfqytgfky")
    public suspend
    fun accountTakeoverRiskConfiguration(`value`: Output<RiskConfigurationAccountTakeoverRiskConfigurationArgs>) {
        this.accountTakeoverRiskConfiguration = value
    }

    /**
     * @param value The app client ID. When the client ID is not provided, the same risk configuration is applied to all the clients in the User Pool.
     */
    @JvmName("ckhwplanhwdrbpgy")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The compromised credentials risk configuration. See details below.
     */
    @JvmName("cfjnbdsxxudtrpke")
    public suspend
    fun compromisedCredentialsRiskConfiguration(`value`: Output<RiskConfigurationCompromisedCredentialsRiskConfigurationArgs>) {
        this.compromisedCredentialsRiskConfiguration = value
    }

    /**
     * @param value The configuration to override the risk decision. See details below.
     */
    @JvmName("vvhpbchyqkxvwjhs")
    public suspend
    fun riskExceptionConfiguration(`value`: Output<RiskConfigurationRiskExceptionConfigurationArgs>) {
        this.riskExceptionConfiguration = value
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("osebxeblqbnibdjo")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The account takeover risk configuration. See details below.
     */
    @JvmName("iaowideboiccoufh")
    public suspend
    fun accountTakeoverRiskConfiguration(`value`: RiskConfigurationAccountTakeoverRiskConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountTakeoverRiskConfiguration = mapped
    }

    /**
     * @param argument The account takeover risk configuration. See details below.
     */
    @JvmName("uuhxdibhhissskeo")
    public suspend
    fun accountTakeoverRiskConfiguration(argument: suspend RiskConfigurationAccountTakeoverRiskConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RiskConfigurationAccountTakeoverRiskConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accountTakeoverRiskConfiguration = mapped
    }

    /**
     * @param value The app client ID. When the client ID is not provided, the same risk configuration is applied to all the clients in the User Pool.
     */
    @JvmName("mdwadugyeokdooxr")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The compromised credentials risk configuration. See details below.
     */
    @JvmName("pjsnxnjfiveedkjo")
    public suspend
    fun compromisedCredentialsRiskConfiguration(`value`: RiskConfigurationCompromisedCredentialsRiskConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compromisedCredentialsRiskConfiguration = mapped
    }

    /**
     * @param argument The compromised credentials risk configuration. See details below.
     */
    @JvmName("hbhdgoyetjmxrsjs")
    public suspend
    fun compromisedCredentialsRiskConfiguration(argument: suspend RiskConfigurationCompromisedCredentialsRiskConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            RiskConfigurationCompromisedCredentialsRiskConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.compromisedCredentialsRiskConfiguration = mapped
    }

    /**
     * @param value The configuration to override the risk decision. See details below.
     */
    @JvmName("mtfgxmdswbxvsouv")
    public suspend
    fun riskExceptionConfiguration(`value`: RiskConfigurationRiskExceptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.riskExceptionConfiguration = mapped
    }

    /**
     * @param argument The configuration to override the risk decision. See details below.
     */
    @JvmName("bhcyxsavvweewrye")
    public suspend
    fun riskExceptionConfiguration(argument: suspend RiskConfigurationRiskExceptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RiskConfigurationRiskExceptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.riskExceptionConfiguration = mapped
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("gxxxwcbyauavmitf")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): RiskConfigurationArgs = RiskConfigurationArgs(
        accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration,
        clientId = clientId,
        compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration,
        riskExceptionConfiguration = riskExceptionConfiguration,
        userPoolId = userPoolId,
    )
}
