@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .username("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Setting user attributes
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool", UserPoolArgs.builder()
 *             .schemas(
 *                 UserPoolSchemaArgs.builder()
 *                     .name("example")
 *                     .attributeDataType("Boolean")
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .build(),
 *                 UserPoolSchemaArgs.builder()
 *                     .name("foo")
 *                     .attributeDataType("String")
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .stringAttributeConstraints()
 *                     .build())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .username("example")
 *             .attributes(Map.ofEntries(
 *                 Map.entry("example", true),
 *                 Map.entry("foo", "bar"),
 *                 Map.entry("email", "no-reply@domain.example"),
 *                 Map.entry("email_verified", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User using the `user_pool_id`/`name` attributes concatenated. For example:
 * ```sh
 *  $ pulumi import aws:cognito/user:User user us-east-1_vG78M4goG/user
 * ```
 * @property attributes A map that contains user attributes and attribute values to be set for the user.
 * @property clientMetadata A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
 * @property desiredDeliveryMediums A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
 * @property enabled Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
 * @property forceAliasCreation If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
 * @property messageAction Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
 * @property password The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
 * @property temporaryPassword The user's temporary password. Conflicts with `password`.
 * @property userPoolId The user pool ID for the user pool where the user will be created.
 * @property username The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
 * The following arguments are optional:
 * @property validationData The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
 * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
 */
public data class UserArgs(
    public val attributes: Output<Map<String, String>>? = null,
    public val clientMetadata: Output<Map<String, String>>? = null,
    public val desiredDeliveryMediums: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val forceAliasCreation: Output<Boolean>? = null,
    public val messageAction: Output<String>? = null,
    public val password: Output<String>? = null,
    public val temporaryPassword: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
    public val username: Output<String>? = null,
    public val validationData: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserArgs = com.pulumi.aws.cognito.UserArgs.builder()
        .attributes(
            attributes?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .clientMetadata(
            clientMetadata?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .desiredDeliveryMediums(
            desiredDeliveryMediums?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        )
        .enabled(enabled?.applyValue({ args0 -> args0 }))
        .forceAliasCreation(forceAliasCreation?.applyValue({ args0 -> args0 }))
        .messageAction(messageAction?.applyValue({ args0 -> args0 }))
        .password(password?.applyValue({ args0 -> args0 }))
        .temporaryPassword(temporaryPassword?.applyValue({ args0 -> args0 }))
        .userPoolId(userPoolId?.applyValue({ args0 -> args0 }))
        .username(username?.applyValue({ args0 -> args0 }))
        .validationData(
            validationData?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    private var clientMetadata: Output<Map<String, String>>? = null

    private var desiredDeliveryMediums: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var forceAliasCreation: Output<Boolean>? = null

    private var messageAction: Output<String>? = null

    private var password: Output<String>? = null

    private var temporaryPassword: Output<String>? = null

    private var userPoolId: Output<String>? = null

    private var username: Output<String>? = null

    private var validationData: Output<Map<String, String>>? = null

    /**
     * @param value A map that contains user attributes and attribute values to be set for the user.
     */
    @JvmName("pwrfsasysnnquybd")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     */
    @JvmName("okwvdsoiifkthdmh")
    public suspend fun clientMetadata(`value`: Output<Map<String, String>>) {
        this.clientMetadata = value
    }

    /**
     * @param value A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("mxgluvinrbhsbgtn")
    public suspend fun desiredDeliveryMediums(`value`: Output<List<String>>) {
        this.desiredDeliveryMediums = value
    }

    @JvmName("iqgoquuivhjaoktd")
    public suspend fun desiredDeliveryMediums(vararg values: Output<String>) {
        this.desiredDeliveryMediums = Output.all(values.asList())
    }

    /**
     * @param values A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("eclodclaxcekqych")
    public suspend fun desiredDeliveryMediums(values: List<Output<String>>) {
        this.desiredDeliveryMediums = Output.all(values)
    }

    /**
     * @param value Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
     */
    @JvmName("oiyjoboamvmmhjky")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
     */
    @JvmName("lwyelywuhdbvctsw")
    public suspend fun forceAliasCreation(`value`: Output<Boolean>) {
        this.forceAliasCreation = value
    }

    /**
     * @param value Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
     */
    @JvmName("bryuidkemkglcssv")
    public suspend fun messageAction(`value`: Output<String>) {
        this.messageAction = value
    }

    /**
     * @param value The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
     */
    @JvmName("swfbcfpjpawnamef")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The user's temporary password. Conflicts with `password`.
     */
    @JvmName("twnbimisgnajjkbx")
    public suspend fun temporaryPassword(`value`: Output<String>) {
        this.temporaryPassword = value
    }

    /**
     * @param value The user pool ID for the user pool where the user will be created.
     */
    @JvmName("lfremvpepcvidgrp")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
     * The following arguments are optional:
     */
    @JvmName("huwgslgrxsxfyfci")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
     */
    @JvmName("veqlgulvpndjqmne")
    public suspend fun validationData(`value`: Output<Map<String, String>>) {
        this.validationData = value
    }

    /**
     * @param value A map that contains user attributes and attribute values to be set for the user.
     */
    @JvmName("mewgmbhntwdgarfb")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values A map that contains user attributes and attribute values to be set for the user.
     */
    @JvmName("abcnxaufkgwgjfnm")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     */
    @JvmName("bnnkrvhgluytavev")
    public suspend fun clientMetadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientMetadata = mapped
    }

    /**
     * @param values A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     */
    @JvmName("ersxhaxnimefplsf")
    public fun clientMetadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientMetadata = mapped
    }

    /**
     * @param value A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("sjeykoojgfihxoxe")
    public suspend fun desiredDeliveryMediums(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredDeliveryMediums = mapped
    }

    /**
     * @param values A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
     */
    @JvmName("sntublucybjqmngh")
    public suspend fun desiredDeliveryMediums(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredDeliveryMediums = mapped
    }

    /**
     * @param value Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
     */
    @JvmName("guitfbikkqarffik")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
     */
    @JvmName("kkxswphwjmtxcwkh")
    public suspend fun forceAliasCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceAliasCreation = mapped
    }

    /**
     * @param value Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
     */
    @JvmName("ahiysxxvcrkalrfv")
    public suspend fun messageAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageAction = mapped
    }

    /**
     * @param value The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
     */
    @JvmName("rcqxkwnrnkdfxwjq")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The user's temporary password. Conflicts with `password`.
     */
    @JvmName("ynhyyfjxuyuwmwnx")
    public suspend fun temporaryPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryPassword = mapped
    }

    /**
     * @param value The user pool ID for the user pool where the user will be created.
     */
    @JvmName("fvaagkdlnbxdsvty")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    /**
     * @param value The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
     * The following arguments are optional:
     */
    @JvmName("ievirvqppttlbgvq")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    /**
     * @param value The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
     */
    @JvmName("tojfucrgngmfucsp")
    public suspend fun validationData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param values The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
     */
    @JvmName("nasjoeyuvsbksdla")
    public fun validationData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        attributes = attributes,
        clientMetadata = clientMetadata,
        desiredDeliveryMediums = desiredDeliveryMediums,
        enabled = enabled,
        forceAliasCreation = forceAliasCreation,
        messageAction = messageAction,
        password = password,
        temporaryPassword = temporaryPassword,
        userPoolId = userPoolId,
        username = username,
        validationData = validationData,
    )
}
