@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserGroup].
 */
@PulumiTagMarker
public class UserGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserGroupArgs = UserGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserGroupArgsBuilder.() -> Unit) {
        val builder = UserGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserGroup {
        val builtJavaResource = com.pulumi.aws.cognito.UserGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserGroup(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cognito.UserGroup;
 * import com.pulumi.aws.cognito.UserGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mainUserPool = new UserPool("mainUserPool");
 *         final var groupRolePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Federated")
 *                     .identifiers("cognito-identity.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRoleWithWebIdentity")
 *                 .conditions(
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("cognito-identity.amazonaws.com:aud")
 *                         .values("us-east-1:12345678-dead-beef-cafe-123456790ab")
 *                         .build(),
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ForAnyValue:StringLike")
 *                         .variable("cognito-identity.amazonaws.com:amr")
 *                         .values("authenticated")
 *                         .build())
 *                 .build())
 *             .build());
 *         var groupRoleRole = new Role("groupRoleRole", RoleArgs.builder()
 *             .assumeRolePolicy(groupRolePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var mainUserGroup = new UserGroup("mainUserGroup", UserGroupArgs.builder()
 *             .userPoolId(mainUserPool.id())
 *             .description("Managed by Pulumi")
 *             .precedence(42)
 *             .roleArn(groupRoleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User Groups using the `user_pool_id`/`name` attributes concatenated. For example:
 * ```sh
 *  $ pulumi import aws:cognito/userGroup:UserGroup group us-east-1_vG78M4goG/user-group
 * ```
 *
 */
public class UserGroup internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserGroup,
) : KotlinCustomResource(javaResource, UserGroupMapper) {
    /**
     * The description of the user group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the user group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The precedence of the user group.
     */
    public val precedence: Output<Int>?
        get() = javaResource.precedence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IAM role to be associated with the user group.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The user pool ID.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })
}

public object UserGroupMapper : ResourceMapper<UserGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserGroup::class == javaResource::class

    override fun map(javaResource: Resource): UserGroup = UserGroup(
        javaResource as
            com.pulumi.aws.cognito.UserGroup,
    )
}

/**
 * @see [UserGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserGroup].
 */
public suspend fun userGroup(name: String, block: suspend UserGroupResourceBuilder.() -> Unit):
    UserGroup {
    val builder = UserGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userGroup(name: String): UserGroup {
    val builder = UserGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
