@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cognito.UserGroup;
 * import com.pulumi.aws.cognito.UserGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mainUserPool = new UserPool("mainUserPool");
 *         final var groupRolePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Federated")
 *                     .identifiers("cognito-identity.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRoleWithWebIdentity")
 *                 .conditions(
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("cognito-identity.amazonaws.com:aud")
 *                         .values("us-east-1:12345678-dead-beef-cafe-123456790ab")
 *                         .build(),
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ForAnyValue:StringLike")
 *                         .variable("cognito-identity.amazonaws.com:amr")
 *                         .values("authenticated")
 *                         .build())
 *                 .build())
 *             .build());
 *         var groupRoleRole = new Role("groupRoleRole", RoleArgs.builder()
 *             .assumeRolePolicy(groupRolePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var mainUserGroup = new UserGroup("mainUserGroup", UserGroupArgs.builder()
 *             .userPoolId(mainUserPool.id())
 *             .description("Managed by Pulumi")
 *             .precedence(42)
 *             .roleArn(groupRoleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User Groups using the `user_pool_id`/`name` attributes concatenated. For example:
 * ```sh
 *  $ pulumi import aws:cognito/userGroup:UserGroup group us-east-1_vG78M4goG/user-group
 * ```
 * @property description The description of the user group.
 * @property name The name of the user group.
 * @property precedence The precedence of the user group.
 * @property roleArn The ARN of the IAM role to be associated with the user group.
 * @property userPoolId The user pool ID.
 */
public data class UserGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val precedence: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserGroupArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserGroupArgs =
        com.pulumi.aws.cognito.UserGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .precedence(precedence?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserGroupArgs].
 */
@PulumiTagMarker
public class UserGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var precedence: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value The description of the user group.
     */
    @JvmName("xqsckdtwsspyfpdd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the user group.
     */
    @JvmName("grqkxsnxeaukxooh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The precedence of the user group.
     */
    @JvmName("chwmmukvqxdouegc")
    public suspend fun precedence(`value`: Output<Int>) {
        this.precedence = value
    }

    /**
     * @param value The ARN of the IAM role to be associated with the user group.
     */
    @JvmName("ubbhmdmtkwamlkkl")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("lclnixujihttujxr")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The description of the user group.
     */
    @JvmName("oryadglcxogvbxkh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the user group.
     */
    @JvmName("wqorgsjjujpmgqwk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The precedence of the user group.
     */
    @JvmName("llqxxnanbylpjfka")
    public suspend fun precedence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.precedence = mapped
    }

    /**
     * @param value The ARN of the IAM role to be associated with the user group.
     */
    @JvmName("kioxxritjeetomqt")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("vdlaidygxlmoxwfy")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): UserGroupArgs = UserGroupArgs(
        description = description,
        name = name,
        precedence = precedence,
        roleArn = roleArn,
        userPoolId = userPoolId,
    )
}
