@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserInGroup].
 */
@PulumiTagMarker
public class UserInGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserInGroupArgs = UserInGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserInGroupArgsBuilder.() -> Unit) {
        val builder = UserInGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserInGroup {
        val builtJavaResource = com.pulumi.aws.cognito.UserInGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserInGroup(builtJavaResource)
    }
}

/**
 * Adds the specified user to the specified group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolPasswordPolicyArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import com.pulumi.aws.cognito.UserGroup;
 * import com.pulumi.aws.cognito.UserGroupArgs;
 * import com.pulumi.aws.cognito.UserInGroup;
 * import com.pulumi.aws.cognito.UserInGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool", UserPoolArgs.builder()
 *             .passwordPolicy(UserPoolPasswordPolicyArgs.builder()
 *                 .temporaryPasswordValidityDays(7)
 *                 .minimumLength(6)
 *                 .requireUppercase(false)
 *                 .requireSymbols(false)
 *                 .requireNumbers(false)
 *                 .build())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .username("example")
 *             .build());
 *         var exampleUserGroup = new UserGroup("exampleUserGroup", UserGroupArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserInGroup = new UserInGroup("exampleUserInGroup", UserInGroupArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .groupName(exampleUserGroup.name())
 *             .username(exampleUser.username())
 *             .build());
 *     }
 * }
 * ```
 */
public class UserInGroup internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserInGroup,
) : KotlinCustomResource(javaResource, UserInGroupMapper) {
    /**
     * The name of the group to which the user is to be added.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * The user pool ID of the user and group.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })

    /**
     * The username of the user to be added to the group.
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })
}

public object UserInGroupMapper : ResourceMapper<UserInGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserInGroup::class == javaResource::class

    override fun map(javaResource: Resource): UserInGroup = UserInGroup(
        javaResource as
            com.pulumi.aws.cognito.UserInGroup,
    )
}

/**
 * @see [UserInGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserInGroup].
 */
public suspend fun userInGroup(name: String, block: suspend UserInGroupResourceBuilder.() -> Unit):
    UserInGroup {
    val builder = UserInGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserInGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userInGroup(name: String): UserInGroup {
    val builder = UserInGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
