@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserInGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds the specified user to the specified group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolPasswordPolicyArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import com.pulumi.aws.cognito.UserGroup;
 * import com.pulumi.aws.cognito.UserGroupArgs;
 * import com.pulumi.aws.cognito.UserInGroup;
 * import com.pulumi.aws.cognito.UserInGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool", UserPoolArgs.builder()
 *             .passwordPolicy(UserPoolPasswordPolicyArgs.builder()
 *                 .temporaryPasswordValidityDays(7)
 *                 .minimumLength(6)
 *                 .requireUppercase(false)
 *                 .requireSymbols(false)
 *                 .requireNumbers(false)
 *                 .build())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .username("example")
 *             .build());
 *         var exampleUserGroup = new UserGroup("exampleUserGroup", UserGroupArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserInGroup = new UserInGroup("exampleUserInGroup", UserInGroupArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .groupName(exampleUserGroup.name())
 *             .username(exampleUser.username())
 *             .build());
 *     }
 * }
 * ```
 * @property groupName The name of the group to which the user is to be added.
 * @property userPoolId The user pool ID of the user and group.
 * @property username The username of the user to be added to the group.
 */
public data class UserInGroupArgs(
    public val groupName: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserInGroupArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserInGroupArgs =
        com.pulumi.aws.cognito.UserInGroupArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserInGroupArgs].
 */
@PulumiTagMarker
public class UserInGroupArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var userPoolId: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The name of the group to which the user is to be added.
     */
    @JvmName("jfxngjhyiolbgkku")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The user pool ID of the user and group.
     */
    @JvmName("hnjpxkvyuydtvaxy")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The username of the user to be added to the group.
     */
    @JvmName("aswaghnshvgrpkun")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The name of the group to which the user is to be added.
     */
    @JvmName("ielxphfyhworjonn")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The user pool ID of the user and group.
     */
    @JvmName("gwhmmoywwqfhnwod")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    /**
     * @param value The username of the user to be added to the group.
     */
    @JvmName("cffhdudljqglviip")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): UserInGroupArgs = UserInGroupArgs(
        groupName = groupName,
        userPoolId = userPoolId,
        username = username,
    )
}
