@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientAnalyticsConfiguration
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientTokenValidityUnits
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientAnalyticsConfiguration.Companion.toKotlin as userPoolClientAnalyticsConfigurationToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.UserPoolClientTokenValidityUnits.Companion.toKotlin as userPoolClientTokenValidityUnitsToKotlin

/**
 * Builder for [UserPoolClient].
 */
@PulumiTagMarker
public class UserPoolClientResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPoolClientArgs = UserPoolClientArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPoolClientArgsBuilder.() -> Unit) {
        val builder = UserPoolClientArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserPoolClient {
        val builtJavaResource = com.pulumi.aws.cognito.UserPoolClient(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPoolClient(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Pool Client resource.
 * To manage a User Pool Client created by another service, such as when [configuring an OpenSearch Domain to use Cognito authentication](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html),
 * use the `aws.cognito.ManagedUserPoolClient` resource instead.
 * ## Example Usage
 * ### Create a basic user pool client
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool");
 *         var client = new UserPoolClient("client", UserPoolClientArgs.builder()
 *             .userPoolId(pool.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a user pool client with no SRP authentication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool");
 *         var client = new UserPoolClient("client", UserPoolClientArgs.builder()
 *             .userPoolId(pool.id())
 *             .generateSecret(true)
 *             .explicitAuthFlows("ADMIN_NO_SRP_AUTH")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a user pool client with pinpoint analytics
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolClientAnalyticsConfigurationArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testUserPool = new UserPool("testUserPool");
 *         var testApp = new App("testApp");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("cognito-idp.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testUserPoolClient = new UserPoolClient("testUserPoolClient", UserPoolClientArgs.builder()
 *             .userPoolId(testUserPool.id())
 *             .analyticsConfiguration(UserPoolClientAnalyticsConfigurationArgs.builder()
 *                 .applicationId(testApp.applicationId())
 *                 .externalId("some_id")
 *                 .roleArn(testRole.arn())
 *                 .userDataShared(true)
 *                 .build())
 *             .build());
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "mobiletargeting:UpdateEndpoint",
 *                     "mobiletargeting:PutEvents")
 *                 .resources(testApp.applicationId().applyValue(applicationId -> String.format("arn:aws:mobiletargeting:*:%s:apps/%s*", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),applicationId)))
 *                 .build())
 *             .build());
 *         var testRolePolicy = new RolePolicy("testRolePolicy", RolePolicyArgs.builder()
 *             .role(testRole.id())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a user pool client with Cognito as the identity provider
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new UserPool("pool");
 *         var userpoolClient = new UserPoolClient("userpoolClient", UserPoolClientArgs.builder()
 *             .userPoolId(pool.id())
 *             .callbackUrls("https://example.com")
 *             .allowedOauthFlowsUserPoolClient(true)
 *             .allowedOauthFlows(
 *                 "code",
 *                 "implicit")
 *             .allowedOauthScopes(
 *                 "email",
 *                 "openid")
 *             .supportedIdentityProviders("COGNITO")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User Pool Clients using the `id` of the Cognito User Pool, and the `id` of the Cognito User Pool Client. For example:
 * ```sh
 *  $ pulumi import aws:cognito/userPoolClient:UserPoolClient client us-west-2_abc123/3ho4ek12345678909nh3fmhpko
 * ```
 *
 */
public class UserPoolClient internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserPoolClient,
) : KotlinCustomResource(javaResource, UserPoolClientMapper) {
    /**
     * Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used.
     * By default, the unit is hours.
     * The unit can be overridden by a value in `token_validity_units.access_token`.
     */
    public val accessTokenValidity: Output<Int>
        get() = javaResource.accessTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed OAuth flows (code, implicit, client_credentials).
     */
    public val allowedOauthFlows: Output<List<String>>
        get() = javaResource.allowedOauthFlows().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Whether the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
     */
    public val allowedOauthFlowsUserPoolClient: Output<Boolean>
        get() = javaResource.allowedOauthFlowsUserPoolClient().applyValue({ args0 -> args0 })

    /**
     * List of allowed OAuth scopes (phone, email, openid, profile, and aws.cognito.signin.user.admin).
     */
    public val allowedOauthScopes: Output<List<String>>
        get() = javaResource.allowedOauthScopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Configuration block for Amazon Pinpoint analytics for collecting metrics for this user pool. Detailed below.
     */
    public val analyticsConfiguration: Output<UserPoolClientAnalyticsConfiguration>?
        get() = javaResource.analyticsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolClientAnalyticsConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Amazon Cognito creates a session token for each API request in an authentication flow. AuthSessionValidity is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires. Valid values between `3` and `15`. Default value is `3`.
     */
    public val authSessionValidity: Output<Int>
        get() = javaResource.authSessionValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed callback URLs for the identity providers.
     */
    public val callbackUrls: Output<List<String>>
        get() = javaResource.callbackUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Client secret of the user pool client.
     */
    public val clientSecret: Output<String>
        get() = javaResource.clientSecret().applyValue({ args0 -> args0 })

    /**
     * Default redirect URI. Must be in the list of callback URLs.
     */
    public val defaultRedirectUri: Output<String>
        get() = javaResource.defaultRedirectUri().applyValue({ args0 -> args0 })

    /**
     * Activates the propagation of additional user context data.
     */
    public val enablePropagateAdditionalUserContextData: Output<Boolean>
        get() = javaResource.enablePropagateAdditionalUserContextData().applyValue({ args0 -> args0 })

    /**
     * Enables or disables token revocation.
     */
    public val enableTokenRevocation: Output<Boolean>
        get() = javaResource.enableTokenRevocation().applyValue({ args0 -> args0 })

    /**
     * List of authentication flows (ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, ALLOW_REFRESH_TOKEN_AUTH).
     */
    public val explicitAuthFlows: Output<List<String>>
        get() = javaResource.explicitAuthFlows().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Should an application secret be generated.
     */
    public val generateSecret: Output<Boolean>?
        get() = javaResource.generateSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used.
     * By default, the unit is hours.
     * The unit can be overridden by a value in `token_validity_units.id_token`.
     */
    public val idTokenValidity: Output<Int>
        get() = javaResource.idTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of allowed logout URLs for the identity providers.
     */
    public val logoutUrls: Output<List<String>>
        get() = javaResource.logoutUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Name of the application client.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
     */
    public val preventUserExistenceErrors: Output<String>
        get() = javaResource.preventUserExistenceErrors().applyValue({ args0 -> args0 })

    /**
     * List of user pool attributes the application client can read from.
     */
    public val readAttributes: Output<List<String>>
        get() = javaResource.readAttributes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used.
     * By default, the unit is days.
     * The unit can be overridden by a value in `token_validity_units.refresh_token`.
     */
    public val refreshTokenValidity: Output<Int>
        get() = javaResource.refreshTokenValidity().applyValue({ args0 -> args0 })

    /**
     * List of provider names for the identity providers that are supported on this client. Uses the `provider_name` attribute of `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     */
    public val supportedIdentityProviders: Output<List<String>>
        get() = javaResource.supportedIdentityProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Configuration block for units in which the validity times are represented in. Detailed below.
     */
    public val tokenValidityUnits: Output<UserPoolClientTokenValidityUnits>?
        get() = javaResource.tokenValidityUnits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userPoolClientTokenValidityUnitsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * User pool the client belongs to.
     * The following arguments are optional:
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })

    /**
     * List of user pool attributes the application client can write to.
     */
    public val writeAttributes: Output<List<String>>
        get() = javaResource.writeAttributes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object UserPoolClientMapper : ResourceMapper<UserPoolClient> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserPoolClient::class == javaResource::class

    override fun map(javaResource: Resource): UserPoolClient = UserPoolClient(
        javaResource as
            com.pulumi.aws.cognito.UserPoolClient,
    )
}

/**
 * @see [UserPoolClient].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPoolClient].
 */
public suspend fun userPoolClient(
    name: String,
    block: suspend UserPoolClientResourceBuilder.() -> Unit,
): UserPoolClient {
    val builder = UserPoolClientResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPoolClient].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPoolClient(name: String): UserPoolClient {
    val builder = UserPoolClientResourceBuilder()
    builder.name(name)
    return builder.build()
}
