@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserPoolDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Pool Domain resource.
 * ## Example Usage
 * ### Amazon Cognito domain
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserPool("example");
 *         var main = new UserPoolDomain("main", UserPoolDomainArgs.builder()
 *             .domain("example-domain")
 *             .userPoolId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Cognito domain
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.route53.Route53Functions;
 * import com.pulumi.aws.route53.inputs.GetZoneArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var main = new UserPoolDomain("main", UserPoolDomainArgs.builder()
 *             .domain("example-domain")
 *             .certificateArn(aws_acm_certificate.cert().arn())
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         final var exampleZone = Route53Functions.getZone(GetZoneArgs.builder()
 *             .name("example.com")
 *             .build());
 *         var auth_cognito_A = new Record("auth-cognito-A", RecordArgs.builder()
 *             .name(main.domain())
 *             .type("A")
 *             .zoneId(exampleZone.applyValue(getZoneResult -> getZoneResult.zoneId()))
 *             .aliases(RecordAliasArgs.builder()
 *                 .evaluateTargetHealth(false)
 *                 .name(main.cloudfrontDistribution())
 *                 .zoneId(main.cloudfrontDistributionZoneId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User Pool Domains using the `domain`. For example:
 * ```sh
 *  $ pulumi import aws:cognito/userPoolDomain:UserPoolDomain main auth.example.org
 * ```
 * @property certificateArn The ARN of an ISSUED ACM certificate in us-east-1 for a custom domain.
 * @property domain For custom domains, this is the fully-qualified domain name, such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such as auth.
 * @property userPoolId The user pool ID.
 */
public data class UserPoolDomainArgs(
    public val certificateArn: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserPoolDomainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserPoolDomainArgs =
        com.pulumi.aws.cognito.UserPoolDomainArgs.builder()
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolDomainArgs].
 */
@PulumiTagMarker
public class UserPoolDomainArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    private var domain: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value The ARN of an ISSUED ACM certificate in us-east-1 for a custom domain.
     */
    @JvmName("utycbdicjfwrwovs")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value For custom domains, this is the fully-qualified domain name, such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such as auth.
     */
    @JvmName("ydosupeayrpbwayp")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("okduqhrrvlrukefg")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The ARN of an ISSUED ACM certificate in us-east-1 for a custom domain.
     */
    @JvmName("srvabwgykaakwlkl")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value For custom domains, this is the fully-qualified domain name, such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such as auth.
     */
    @JvmName("oeoiwbgstjlvjqjj")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The user pool ID.
     */
    @JvmName("dtslkexmbyygsmwk")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): UserPoolDomainArgs = UserPoolDomainArgs(
        certificateArn = certificateArn,
        domain = domain,
        userPoolId = userPoolId,
    )
}
