@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserPoolUICustomization].
 */
@PulumiTagMarker
public class UserPoolUICustomizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPoolUICustomizationArgs = UserPoolUICustomizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPoolUICustomizationArgsBuilder.() -> Unit) {
        val builder = UserPoolUICustomizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserPoolUICustomization {
        val builtJavaResource = com.pulumi.aws.cognito.UserPoolUICustomization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPoolUICustomization(builtJavaResource)
    }
}

/**
 * Provides a Cognito User Pool UI Customization resource.
 * > **Note:** To use this resource, the user pool must have a domain associated with it. For more information, see the Amazon Cognito Developer Guide on [Customizing the Built-in Sign-In and Sign-up Webpages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-ui-customization.html).
 * ## Example Usage
 * ### UI customization settings for a single client
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import com.pulumi.aws.cognito.UserPoolUICustomization;
 * import com.pulumi.aws.cognito.UserPoolUICustomizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var exampleUserPoolDomain = new UserPoolDomain("exampleUserPoolDomain", UserPoolDomainArgs.builder()
 *             .domain("example")
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolClient = new UserPoolClient("exampleUserPoolClient", UserPoolClientArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolUICustomization = new UserPoolUICustomization("exampleUserPoolUICustomization", UserPoolUICustomizationArgs.builder()
 *             .clientId(exampleUserPoolClient.id())
 *             .css(".label-customizable {font-weight: 400;}")
 *             .imageFile(Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get("logo.png"))))
 *             .userPoolId(exampleUserPoolDomain.userPoolId())
 *             .build());
 *     }
 * }
 * ```
 * ### UI customization settings for all clients
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.cognito.UserPoolUICustomization;
 * import com.pulumi.aws.cognito.UserPoolUICustomizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var exampleUserPoolDomain = new UserPoolDomain("exampleUserPoolDomain", UserPoolDomainArgs.builder()
 *             .domain("example")
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolUICustomization = new UserPoolUICustomization("exampleUserPoolUICustomization", UserPoolUICustomizationArgs.builder()
 *             .css(".label-customizable {font-weight: 400;}")
 *             .imageFile(Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get("logo.png"))))
 *             .userPoolId(exampleUserPoolDomain.userPoolId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User Pool UI Customizations using the `user_pool_id` and `client_id` separated by `,`. For example:
 * ```sh
 *  $ pulumi import aws:cognito/userPoolUICustomization:UserPoolUICustomization example us-west-2_ZCTarbt5C,12bu4fuk3mlgqa2rtrujgp6egq
 * ```
 *
 */
public class UserPoolUICustomization internal constructor(
    override val javaResource: com.pulumi.aws.cognito.UserPoolUICustomization,
) : KotlinCustomResource(javaResource, UserPoolUICustomizationMapper) {
    /**
     * The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
     */
    public val clientId: Output<String>?
        get() = javaResource.clientId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The creation date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
     */
    public val css: Output<String>?
        get() = javaResource.css().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The CSS version number.
     */
    public val cssVersion: Output<String>
        get() = javaResource.cssVersion().applyValue({ args0 -> args0 })

    /**
     * The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
     */
    public val imageFile: Output<String>?
        get() = javaResource.imageFile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The logo image URL for the UI customization.
     */
    public val imageUrl: Output<String>
        get() = javaResource.imageUrl().applyValue({ args0 -> args0 })

    /**
     * The last-modified date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) for the UI customization.
     */
    public val lastModifiedDate: Output<String>
        get() = javaResource.lastModifiedDate().applyValue({ args0 -> args0 })

    /**
     * The user pool ID for the user pool.
     */
    public val userPoolId: Output<String>
        get() = javaResource.userPoolId().applyValue({ args0 -> args0 })
}

public object UserPoolUICustomizationMapper : ResourceMapper<UserPoolUICustomization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.UserPoolUICustomization::class == javaResource::class

    override fun map(javaResource: Resource): UserPoolUICustomization =
        UserPoolUICustomization(javaResource as com.pulumi.aws.cognito.UserPoolUICustomization)
}

/**
 * @see [UserPoolUICustomization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPoolUICustomization].
 */
public suspend fun userPoolUICustomization(
    name: String,
    block: suspend UserPoolUICustomizationResourceBuilder.() -> Unit,
): UserPoolUICustomization {
    val builder = UserPoolUICustomizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPoolUICustomization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPoolUICustomization(name: String): UserPoolUICustomization {
    val builder = UserPoolUICustomizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
