@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.UserPoolUICustomizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cognito User Pool UI Customization resource.
 * > **Note:** To use this resource, the user pool must have a domain associated with it. For more information, see the Amazon Cognito Developer Guide on [Customizing the Built-in Sign-In and Sign-up Webpages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-ui-customization.html).
 * ## Example Usage
 * ### UI customization settings for a single client
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import com.pulumi.aws.cognito.UserPoolUICustomization;
 * import com.pulumi.aws.cognito.UserPoolUICustomizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var exampleUserPoolDomain = new UserPoolDomain("exampleUserPoolDomain", UserPoolDomainArgs.builder()
 *             .domain("example")
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolClient = new UserPoolClient("exampleUserPoolClient", UserPoolClientArgs.builder()
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolUICustomization = new UserPoolUICustomization("exampleUserPoolUICustomization", UserPoolUICustomizationArgs.builder()
 *             .clientId(exampleUserPoolClient.id())
 *             .css(".label-customizable {font-weight: 400;}")
 *             .imageFile(Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get("logo.png"))))
 *             .userPoolId(exampleUserPoolDomain.userPoolId())
 *             .build());
 *     }
 * }
 * ```
 * ### UI customization settings for all clients
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.cognito.UserPoolUICustomization;
 * import com.pulumi.aws.cognito.UserPoolUICustomizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var exampleUserPoolDomain = new UserPoolDomain("exampleUserPoolDomain", UserPoolDomainArgs.builder()
 *             .domain("example")
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolUICustomization = new UserPoolUICustomization("exampleUserPoolUICustomization", UserPoolUICustomizationArgs.builder()
 *             .css(".label-customizable {font-weight: 400;}")
 *             .imageFile(Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get("logo.png"))))
 *             .userPoolId(exampleUserPoolDomain.userPoolId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cognito User Pool UI Customizations using the `user_pool_id` and `client_id` separated by `,`. For example:
 * ```sh
 *  $ pulumi import aws:cognito/userPoolUICustomization:UserPoolUICustomization example us-west-2_ZCTarbt5C,12bu4fuk3mlgqa2rtrujgp6egq
 * ```
 * @property clientId The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
 * @property css The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
 * @property imageFile The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
 * @property userPoolId The user pool ID for the user pool.
 */
public data class UserPoolUICustomizationArgs(
    public val clientId: Output<String>? = null,
    public val css: Output<String>? = null,
    public val imageFile: Output<String>? = null,
    public val userPoolId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.UserPoolUICustomizationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.UserPoolUICustomizationArgs =
        com.pulumi.aws.cognito.UserPoolUICustomizationArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .css(css?.applyValue({ args0 -> args0 }))
            .imageFile(imageFile?.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolUICustomizationArgs].
 */
@PulumiTagMarker
public class UserPoolUICustomizationArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var css: Output<String>? = null

    private var imageFile: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
     */
    @JvmName("yufmnvugeuoxitpo")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
     */
    @JvmName("ybdtkefonejpojwm")
    public suspend fun css(`value`: Output<String>) {
        this.css = value
    }

    /**
     * @param value The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
     */
    @JvmName("fmevlxcupkuljgdg")
    public suspend fun imageFile(`value`: Output<String>) {
        this.imageFile = value
    }

    /**
     * @param value The user pool ID for the user pool.
     */
    @JvmName("rdpoiuunahngprei")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value The client ID for the client app. Defaults to `ALL`. If `ALL` is specified, the `css` and/or `image_file` settings will be used for every client that has no UI customization set previously.
     */
    @JvmName("csbqhwheqfifoefb")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The CSS values in the UI customization, provided as a String. At least one of `css` or `image_file` is required.
     */
    @JvmName("qmxedchiswyssoln")
    public suspend fun css(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.css = mapped
    }

    /**
     * @param value The uploaded logo image for the UI customization, provided as a base64-encoded String. Drift detection is not possible for this argument. At least one of `css` or `image_file` is required.
     */
    @JvmName("txxtbyxxhljhnkbd")
    public suspend fun imageFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageFile = mapped
    }

    /**
     * @param value The user pool ID for the user pool.
     */
    @JvmName("ishtqteufuiinsbg")
    public suspend fun userPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): UserPoolUICustomizationArgs = UserPoolUICustomizationArgs(
        clientId = clientId,
        css = css,
        imageFile = imageFile,
        userPoolId = userPoolId,
    )
}
