@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.GetUserPoolClientPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserPoolClient.
 * @property clientId Client Id of the user pool.
 * @property userPoolId User pool the client belongs to.
 */
public data class GetUserPoolClientPlainArgs(
    public val clientId: String,
    public val userPoolId: String,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.GetUserPoolClientPlainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.GetUserPoolClientPlainArgs =
        com.pulumi.aws.cognito.inputs.GetUserPoolClientPlainArgs.builder()
            .clientId(clientId.let({ args0 -> args0 }))
            .userPoolId(userPoolId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPoolClientPlainArgs].
 */
@PulumiTagMarker
public class GetUserPoolClientPlainArgsBuilder internal constructor() {
    private var clientId: String? = null

    private var userPoolId: String? = null

    /**
     * @param value Client Id of the user pool.
     */
    @JvmName("kfmamsnvmwtwojkv")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clientId = mapped
    }

    /**
     * @param value User pool the client belongs to.
     */
    @JvmName("xfkeycmqsdqnliln")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userPoolId = mapped
    }

    internal fun build(): GetUserPoolClientPlainArgs = GetUserPoolClientPlainArgs(
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
    )
}
