@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.GetUserPoolClientsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserPoolClients.
 * @property userPoolId Cognito user pool ID.
 */
public data class GetUserPoolClientsPlainArgs(
    public val userPoolId: String,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.GetUserPoolClientsPlainArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.GetUserPoolClientsPlainArgs =
        com.pulumi.aws.cognito.inputs.GetUserPoolClientsPlainArgs.builder()
            .userPoolId(userPoolId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPoolClientsPlainArgs].
 */
@PulumiTagMarker
public class GetUserPoolClientsPlainArgsBuilder internal constructor() {
    private var userPoolId: String? = null

    /**
     * @param value Cognito user pool ID.
     */
    @JvmName("tvqkikmfyxmsbadm")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userPoolId = mapped
    }

    internal fun build(): GetUserPoolClientsPlainArgs = GetUserPoolClientsPlainArgs(
        userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
    )
}
