@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.IdentityPoolCognitoIdentityProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId The client ID for the Amazon Cognito Identity User Pool.
 * @property providerName The provider name for an Amazon Cognito Identity User Pool.
 * @property serverSideTokenCheck Whether server-side token validation is enabled for the identity provider’s token or not.
 */
public data class IdentityPoolCognitoIdentityProviderArgs(
    public val clientId: Output<String>? = null,
    public val providerName: Output<String>? = null,
    public val serverSideTokenCheck: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.IdentityPoolCognitoIdentityProviderArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.IdentityPoolCognitoIdentityProviderArgs =
        com.pulumi.aws.cognito.inputs.IdentityPoolCognitoIdentityProviderArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .serverSideTokenCheck(serverSideTokenCheck?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityPoolCognitoIdentityProviderArgs].
 */
@PulumiTagMarker
public class IdentityPoolCognitoIdentityProviderArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var providerName: Output<String>? = null

    private var serverSideTokenCheck: Output<Boolean>? = null

    /**
     * @param value The client ID for the Amazon Cognito Identity User Pool.
     */
    @JvmName("oahfuuajjcsammow")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The provider name for an Amazon Cognito Identity User Pool.
     */
    @JvmName("vdqdcmulyrrwbtfi")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value Whether server-side token validation is enabled for the identity provider’s token or not.
     */
    @JvmName("tqfbsxmifausybng")
    public suspend fun serverSideTokenCheck(`value`: Output<Boolean>) {
        this.serverSideTokenCheck = value
    }

    /**
     * @param value The client ID for the Amazon Cognito Identity User Pool.
     */
    @JvmName("ufyepvliidhvaatr")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The provider name for an Amazon Cognito Identity User Pool.
     */
    @JvmName("gyiqqcromouidkeg")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value Whether server-side token validation is enabled for the identity provider’s token or not.
     */
    @JvmName("nkwdykfuseiopkaq")
    public suspend fun serverSideTokenCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideTokenCheck = mapped
    }

    internal fun build(): IdentityPoolCognitoIdentityProviderArgs =
        IdentityPoolCognitoIdentityProviderArgs(
            clientId = clientId,
            providerName = providerName,
            serverSideTokenCheck = serverSideTokenCheck,
        )
}
