@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ambiguousRoleResolution Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
 * @property identityProvider A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `aws.cognito.IdentityPool` resource or a `aws.cognito.IdentityProvider` resource.
 * @property mappingRules The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
 * @property type The role mapping type.
 */
public data class IdentityPoolRoleAttachmentRoleMappingArgs(
    public val ambiguousRoleResolution: Output<String>? = null,
    public val identityProvider: Output<String>,
    public val mappingRules: Output<List<IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs>>? =
        null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingArgs =
        com.pulumi.aws.cognito.inputs.IdentityPoolRoleAttachmentRoleMappingArgs.builder()
            .ambiguousRoleResolution(ambiguousRoleResolution?.applyValue({ args0 -> args0 }))
            .identityProvider(identityProvider.applyValue({ args0 -> args0 }))
            .mappingRules(
                mappingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityPoolRoleAttachmentRoleMappingArgs].
 */
@PulumiTagMarker
public class IdentityPoolRoleAttachmentRoleMappingArgsBuilder internal constructor() {
    private var ambiguousRoleResolution: Output<String>? = null

    private var identityProvider: Output<String>? = null

    private var mappingRules: Output<List<IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
     */
    @JvmName("jrdddeigodddsyfm")
    public suspend fun ambiguousRoleResolution(`value`: Output<String>) {
        this.ambiguousRoleResolution = value
    }

    /**
     * @param value A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `aws.cognito.IdentityPool` resource or a `aws.cognito.IdentityProvider` resource.
     */
    @JvmName("foynextgoytnjiou")
    public suspend fun identityProvider(`value`: Output<String>) {
        this.identityProvider = value
    }

    /**
     * @param value The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
     */
    @JvmName("xwnlvyvifvttirrm")
    public suspend
    fun mappingRules(`value`: Output<List<IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs>>) {
        this.mappingRules = value
    }

    @JvmName("oucherbldfdxiwam")
    public suspend fun mappingRules(
        vararg
        values: Output<IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs>,
    ) {
        this.mappingRules = Output.all(values.asList())
    }

    /**
     * @param values The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
     */
    @JvmName("tnmipqedelfrvbaa")
    public suspend
    fun mappingRules(values: List<Output<IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs>>) {
        this.mappingRules = Output.all(values)
    }

    /**
     * @param value The role mapping type.
     */
    @JvmName("quvgvkwqrqiaeuip")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
     */
    @JvmName("vixvsyipscnskpvf")
    public suspend fun ambiguousRoleResolution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ambiguousRoleResolution = mapped
    }

    /**
     * @param value A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `aws.cognito.IdentityPool` resource or a `aws.cognito.IdentityProvider` resource.
     */
    @JvmName("dyisutpdaeatmpoa")
    public suspend fun identityProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProvider = mapped
    }

    /**
     * @param value The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
     */
    @JvmName("goshwbpcpkfscqqn")
    public suspend
    fun mappingRules(`value`: List<IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRules = mapped
    }

    /**
     * @param argument The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
     */
    @JvmName("ujnlyovtjffjydnx")
    public suspend
    fun mappingRules(argument: List<suspend IdentityPoolRoleAttachmentRoleMappingMappingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IdentityPoolRoleAttachmentRoleMappingMappingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mappingRules = mapped
    }

    /**
     * @param argument The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
     */
    @JvmName("sqghocnrnltegpxp")
    public suspend fun mappingRules(
        vararg
        argument: suspend IdentityPoolRoleAttachmentRoleMappingMappingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IdentityPoolRoleAttachmentRoleMappingMappingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mappingRules = mapped
    }

    /**
     * @param argument The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
     */
    @JvmName("mejcyjgrgnsnmvev")
    public suspend
    fun mappingRules(argument: suspend IdentityPoolRoleAttachmentRoleMappingMappingRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                IdentityPoolRoleAttachmentRoleMappingMappingRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.mappingRules = mapped
    }

    /**
     * @param values The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
     */
    @JvmName("jqhkbcvqequfsuwp")
    public suspend fun mappingRules(
        vararg
        values: IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappingRules = mapped
    }

    /**
     * @param value The role mapping type.
     */
    @JvmName("wahbwxgvjyliuclb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityPoolRoleAttachmentRoleMappingArgs =
        IdentityPoolRoleAttachmentRoleMappingArgs(
            ambiguousRoleResolution = ambiguousRoleResolution,
            identityProvider = identityProvider ?: throw PulumiNullFieldException("identityProvider"),
            mappingRules = mappingRules,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
