@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.ManagedUserPoolClientAnalyticsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationArn Application ARN for an Amazon Pinpoint application. It conflicts with `external_id` and `role_arn`.
 * @property applicationId Unique identifier for an Amazon Pinpoint application.
 * @property externalId ID for the Analytics Configuration and conflicts with `application_arn`.
 * @property roleArn ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. It conflicts with `application_arn`.
 * @property userDataShared If `user_data_shared` is set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
 */
public data class ManagedUserPoolClientAnalyticsConfigurationArgs(
    public val applicationArn: Output<String>? = null,
    public val applicationId: Output<String>? = null,
    public val externalId: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val userDataShared: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.ManagedUserPoolClientAnalyticsConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.cognito.inputs.ManagedUserPoolClientAnalyticsConfigurationArgs =
        com.pulumi.aws.cognito.inputs.ManagedUserPoolClientAnalyticsConfigurationArgs.builder()
            .applicationArn(applicationArn?.applyValue({ args0 -> args0 }))
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .userDataShared(userDataShared?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedUserPoolClientAnalyticsConfigurationArgs].
 */
@PulumiTagMarker
public class ManagedUserPoolClientAnalyticsConfigurationArgsBuilder internal constructor() {
    private var applicationArn: Output<String>? = null

    private var applicationId: Output<String>? = null

    private var externalId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var userDataShared: Output<Boolean>? = null

    /**
     * @param value Application ARN for an Amazon Pinpoint application. It conflicts with `external_id` and `role_arn`.
     */
    @JvmName("ptxtjayhqbfnmnav")
    public suspend fun applicationArn(`value`: Output<String>) {
        this.applicationArn = value
    }

    /**
     * @param value Unique identifier for an Amazon Pinpoint application.
     */
    @JvmName("ghclombhrvslawpj")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value ID for the Analytics Configuration and conflicts with `application_arn`.
     */
    @JvmName("sdeuuudivsoqprmh")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. It conflicts with `application_arn`.
     */
    @JvmName("vrlnwnnxjamowtyp")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value If `user_data_shared` is set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
     */
    @JvmName("hwihrevvkhjmwule")
    public suspend fun userDataShared(`value`: Output<Boolean>) {
        this.userDataShared = value
    }

    /**
     * @param value Application ARN for an Amazon Pinpoint application. It conflicts with `external_id` and `role_arn`.
     */
    @JvmName("hqnxfqjgrxjpuruu")
    public suspend fun applicationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationArn = mapped
    }

    /**
     * @param value Unique identifier for an Amazon Pinpoint application.
     */
    @JvmName("wlsorxhjookgydwe")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value ID for the Analytics Configuration and conflicts with `application_arn`.
     */
    @JvmName("ccgufxewpngiqhpi")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. It conflicts with `application_arn`.
     */
    @JvmName("wovnmxsynhltwfcy")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value If `user_data_shared` is set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
     */
    @JvmName("mdmcuivdbtnllehh")
    public suspend fun userDataShared(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataShared = mapped
    }

    internal fun build(): ManagedUserPoolClientAnalyticsConfigurationArgs =
        ManagedUserPoolClientAnalyticsConfigurationArgs(
            applicationArn = applicationArn,
            applicationId = applicationId,
            externalId = externalId,
            roleArn = roleArn,
            userDataShared = userDataShared,
        )
}
