@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.ManagedUserPoolClientTokenValidityUnitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken Time unit for the value in `access_token_validity` and defaults to `hours`.
 * @property idToken Time unit for the value in `id_token_validity`, and it defaults to `hours`.
 * @property refreshToken Time unit for the value in `refresh_token_validity` and defaults to `days`.
 */
public data class ManagedUserPoolClientTokenValidityUnitsArgs(
    public val accessToken: Output<String>? = null,
    public val idToken: Output<String>? = null,
    public val refreshToken: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.ManagedUserPoolClientTokenValidityUnitsArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.ManagedUserPoolClientTokenValidityUnitsArgs =
        com.pulumi.aws.cognito.inputs.ManagedUserPoolClientTokenValidityUnitsArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .idToken(idToken?.applyValue({ args0 -> args0 }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedUserPoolClientTokenValidityUnitsArgs].
 */
@PulumiTagMarker
public class ManagedUserPoolClientTokenValidityUnitsArgsBuilder internal constructor() {
    private var accessToken: Output<String>? = null

    private var idToken: Output<String>? = null

    private var refreshToken: Output<String>? = null

    /**
     * @param value Time unit for the value in `access_token_validity` and defaults to `hours`.
     */
    @JvmName("fleuooeglxieaykf")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value Time unit for the value in `id_token_validity`, and it defaults to `hours`.
     */
    @JvmName("jympvckajvyamwjm")
    public suspend fun idToken(`value`: Output<String>) {
        this.idToken = value
    }

    /**
     * @param value Time unit for the value in `refresh_token_validity` and defaults to `days`.
     */
    @JvmName("sbsbogbhpckbijdy")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value Time unit for the value in `access_token_validity` and defaults to `hours`.
     */
    @JvmName("fbtjeubdfnmwncpd")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Time unit for the value in `id_token_validity`, and it defaults to `hours`.
     */
    @JvmName("ixehcupmpppdefaw")
    public suspend fun idToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idToken = mapped
    }

    /**
     * @param value Time unit for the value in `refresh_token_validity` and defaults to `days`.
     */
    @JvmName("awmkxlgtxresaqre")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    internal fun build(): ManagedUserPoolClientTokenValidityUnitsArgs =
        ManagedUserPoolClientTokenValidityUnitsArgs(
            accessToken = accessToken,
            idToken = idToken,
            refreshToken = refreshToken,
        )
}
