@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.ResourceServerScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scopeDescription The scope description.
 * @property scopeName The scope name.
 */
public data class ResourceServerScopeArgs(
    public val scopeDescription: Output<String>,
    public val scopeName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.ResourceServerScopeArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.ResourceServerScopeArgs =
        com.pulumi.aws.cognito.inputs.ResourceServerScopeArgs.builder()
            .scopeDescription(scopeDescription.applyValue({ args0 -> args0 }))
            .scopeName(scopeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceServerScopeArgs].
 */
@PulumiTagMarker
public class ResourceServerScopeArgsBuilder internal constructor() {
    private var scopeDescription: Output<String>? = null

    private var scopeName: Output<String>? = null

    /**
     * @param value The scope description.
     */
    @JvmName("kkocxruvcwywufkk")
    public suspend fun scopeDescription(`value`: Output<String>) {
        this.scopeDescription = value
    }

    /**
     * @param value The scope name.
     */
    @JvmName("ahigtkcvljfgghcg")
    public suspend fun scopeName(`value`: Output<String>) {
        this.scopeName = value
    }

    /**
     * @param value The scope description.
     */
    @JvmName("gbjolxxgyaodcbbc")
    public suspend fun scopeDescription(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopeDescription = mapped
    }

    /**
     * @param value The scope name.
     */
    @JvmName("uwberyhtbqlbvnhb")
    public suspend fun scopeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopeName = mapped
    }

    internal fun build(): ResourceServerScopeArgs = ResourceServerScopeArgs(
        scopeDescription = scopeDescription ?: throw PulumiNullFieldException("scopeDescription"),
        scopeName = scopeName ?: throw PulumiNullFieldException("scopeName"),
    )
}
