@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property highAction Action to take for a high risk. See action block below.
 * @property lowAction Action to take for a low risk. See action block below.
 * @property mediumAction Action to take for a medium risk. See action block below.
 */
public data class RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs(
    public val highAction:
    Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs>? = null,
    public val lowAction:
    Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs>? = null,
    public val mediumAction:
    Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumActionArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs> {
    override fun toJava():
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs.builder()
            .highAction(highAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lowAction(lowAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mediumAction(mediumAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs].
 */
@PulumiTagMarker
public class RiskConfigurationAccountTakeoverRiskConfigurationActionsArgsBuilder internal
constructor() {
    private var highAction:
        Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs>? = null

    private var lowAction:
        Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs>? = null

    private var mediumAction:
        Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumActionArgs>? = null

    /**
     * @param value Action to take for a high risk. See action block below.
     */
    @JvmName("oocuikdejeqtuyky")
    public suspend
    fun highAction(`value`: Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs>) {
        this.highAction = value
    }

    /**
     * @param value Action to take for a low risk. See action block below.
     */
    @JvmName("wjqnorerkqquebjm")
    public suspend
    fun lowAction(`value`: Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs>) {
        this.lowAction = value
    }

    /**
     * @param value Action to take for a medium risk. See action block below.
     */
    @JvmName("wboehndrhroyspfk")
    public suspend
    fun mediumAction(`value`: Output<RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumActionArgs>) {
        this.mediumAction = value
    }

    /**
     * @param value Action to take for a high risk. See action block below.
     */
    @JvmName("krbkijtrvcrxdesp")
    public suspend
    fun highAction(`value`: RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highAction = mapped
    }

    /**
     * @param argument Action to take for a high risk. See action block below.
     */
    @JvmName("elkifkgolrdfqpya")
    public suspend
    fun highAction(argument: suspend RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.highAction = mapped
    }

    /**
     * @param value Action to take for a low risk. See action block below.
     */
    @JvmName("cilsnwgvlysldgay")
    public suspend
    fun lowAction(`value`: RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lowAction = mapped
    }

    /**
     * @param argument Action to take for a low risk. See action block below.
     */
    @JvmName("uwtemmaianfhxwsr")
    public suspend
    fun lowAction(argument: suspend RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.lowAction = mapped
    }

    /**
     * @param value Action to take for a medium risk. See action block below.
     */
    @JvmName("fuyawhritfshtdfv")
    public suspend
    fun mediumAction(`value`: RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediumAction = mapped
    }

    /**
     * @param argument Action to take for a medium risk. See action block below.
     */
    @JvmName("ecpokgftybbqhcad")
    public suspend
    fun mediumAction(argument: suspend RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.mediumAction = mapped
    }

    internal fun build(): RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs =
        RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs(
            highAction = highAction,
            lowAction = lowAction,
            mediumAction = mediumAction,
        )
}
