@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventAction The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
 * @property notify Whether to send a notification.
 */
public data class RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs(
    public val eventAction: Output<String>,
    public val notify: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs> {
    override fun toJava():
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs.builder()
            .eventAction(eventAction.applyValue({ args0 -> args0 }))
            .notify_(notify.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs].
 */
@PulumiTagMarker
public class RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgsBuilder internal
constructor() {
    private var eventAction: Output<String>? = null

    private var notify: Output<Boolean>? = null

    /**
     * @param value The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
     */
    @JvmName("sccggnoxhlolowrb")
    public suspend fun eventAction(`value`: Output<String>) {
        this.eventAction = value
    }

    /**
     * @param value Whether to send a notification.
     */
    @JvmName("wvvpaiyivrajokmb")
    public suspend fun notify(`value`: Output<Boolean>) {
        this.notify = value
    }

    /**
     * @param value The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
     */
    @JvmName("bnfvhfejxcqktjmb")
    public suspend fun eventAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventAction = mapped
    }

    /**
     * @param value Whether to send a notification.
     */
    @JvmName("hocenrhmmxptxaxo")
    public suspend fun notify(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notify = mapped
    }

    internal fun build(): RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs =
        RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs(
            eventAction = eventAction ?: throw PulumiNullFieldException("eventAction"),
            notify = notify ?: throw PulumiNullFieldException("notify"),
        )
}
