@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property htmlBody The email HTML body.
 * @property subject The email subject.
 * @property textBody The email text body.
 */
public data class
RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs(
    public val htmlBody: Output<String>,
    public val subject: Output<String>,
    public val textBody: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs> {
    override fun toJava():
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs.builder()
            .htmlBody(htmlBody.applyValue({ args0 -> args0 }))
            .subject(subject.applyValue({ args0 -> args0 }))
            .textBody(textBody.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs].
 */
@PulumiTagMarker
public class
RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgsBuilder
internal constructor() {
    private var htmlBody: Output<String>? = null

    private var subject: Output<String>? = null

    private var textBody: Output<String>? = null

    /**
     * @param value The email HTML body.
     */
    @JvmName("koddybnuiaffyped")
    public suspend fun htmlBody(`value`: Output<String>) {
        this.htmlBody = value
    }

    /**
     * @param value The email subject.
     */
    @JvmName("oirbkbngakbtpmpx")
    public suspend fun subject(`value`: Output<String>) {
        this.subject = value
    }

    /**
     * @param value The email text body.
     */
    @JvmName("vpjfmxuejkcnxesk")
    public suspend fun textBody(`value`: Output<String>) {
        this.textBody = value
    }

    /**
     * @param value The email HTML body.
     */
    @JvmName("bfqpgansluvxwcrl")
    public suspend fun htmlBody(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.htmlBody = mapped
    }

    /**
     * @param value The email subject.
     */
    @JvmName("uohxrmnsquabybbv")
    public suspend fun subject(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param value The email text body.
     */
    @JvmName("bsjjblvmigdvnhvs")
    public suspend fun textBody(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textBody = mapped
    }

    internal fun build():
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs =
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs(
            htmlBody = htmlBody ?: throw PulumiNullFieldException("htmlBody"),
            subject = subject ?: throw PulumiNullFieldException("subject"),
            textBody = textBody ?: throw PulumiNullFieldException("textBody"),
        )
}
