@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventAction The event action. Valid values are `BLOCK` or `NO_ACTION`.
 */
public data class RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs(
    public val eventAction: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs> {
    override fun toJava():
        com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs =
        com.pulumi.aws.cognito.inputs.RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs.builder()
            .eventAction(eventAction.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs].
 */
@PulumiTagMarker
public class RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgsBuilder internal
constructor() {
    private var eventAction: Output<String>? = null

    /**
     * @param value The event action. Valid values are `BLOCK` or `NO_ACTION`.
     */
    @JvmName("aycmdjrgcesdkiie")
    public suspend fun eventAction(`value`: Output<String>) {
        this.eventAction = value
    }

    /**
     * @param value The event action. Valid values are `BLOCK` or `NO_ACTION`.
     */
    @JvmName("knhadmnrihoqxqyw")
    public suspend fun eventAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventAction = mapped
    }

    internal fun build(): RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs =
        RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs(
            eventAction = eventAction ?: throw PulumiNullFieldException("eventAction"),
        )
}
